/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.utils;

import com.teamresourceful.resourcefullib.client.screens.CursorScreen;
import com.teamresourceful.resourcefullib.common.exceptions.UtilityClassException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.lwjgl.glfw.GLFW;

public final class CursorUtils {
    private static final long DEFAULT_CURSOR = GLFW.glfwCreateStandardCursor((int)221185);
    private static final long POINTING_CURSOR = GLFW.glfwCreateStandardCursor((int)221188);
    private static final long DISABLED_CURSOR = GLFW.glfwCreateStandardCursor((int)221194);
    private static final long TEXT_CURSOR = GLFW.glfwCreateStandardCursor((int)221186);
    private static final long CROSSHAIR_CURSOR = GLFW.glfwCreateStandardCursor((int)221187);
    private static final long RESIZE_EW_CURSOR = GLFW.glfwCreateStandardCursor((int)221189);
    private static final long RESIZE_NS_CURSOR = GLFW.glfwCreateStandardCursor((int)221190);
    private static final long RESIZE_NWSE_CURSOR = GLFW.glfwCreateStandardCursor((int)221191);
    private static final long RESIZE_NESW_CURSOR = GLFW.glfwCreateStandardCursor((int)221192);
    private static final long RESIZE_ALL_CURSOR = GLFW.glfwCreateStandardCursor((int)221193);

    private CursorUtils() throws UtilityClassException {
        throw new UtilityClassException();
    }

    public static void setDefault() {
        GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)DEFAULT_CURSOR);
    }

    public static void setPointing() {
        GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)POINTING_CURSOR);
    }

    public static void setDisabled() {
        GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)DISABLED_CURSOR);
    }

    public static void setText() {
        GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)TEXT_CURSOR);
    }

    public static void setCrosshair() {
        GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)CROSSHAIR_CURSOR);
    }

    public static void setResizeEastWest() {
        GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)RESIZE_EW_CURSOR);
    }

    public static void setResizeNorthSouth() {
        GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)RESIZE_NS_CURSOR);
    }

    public static void setResizeNorthWestSouthEast() {
        GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)RESIZE_NWSE_CURSOR);
    }

    public static void setResizeNorthEastSouthWest() {
        GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)RESIZE_NESW_CURSOR);
    }

    public static void setResizeAll() {
        GLFW.glfwSetCursor((long)Minecraft.getInstance().getWindow().getWindow(), (long)RESIZE_ALL_CURSOR);
    }

    public static void setCursor(boolean state, CursorScreen.Cursor cursor) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof CursorScreen) {
            CursorScreen cursorScreen = (CursorScreen)screen;
            if (state) {
                cursorScreen.setCursor(cursor);
            }
        }
    }
}

