/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.codecs.tags;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

public class HolderSetCodec<E>
implements Codec<HolderSet<E>> {
    private final Registry<E> registry;
    private final Codec<Either<TagKey<E>, List<Holder<E>>>> holderCodec;

    private HolderSetCodec(Registry<E> registry, Codec<Holder<E>> codec) {
        this.registry = registry;
        this.holderCodec = Codec.either((Codec)TagKey.hashedCodec((ResourceKey)registry.key()), HolderSetCodec.holderListCodec(codec));
    }

    public static <E> HolderSetCodec<E> of(Registry<E> registry) {
        return new HolderSetCodec<E>(registry, registry.holderByNameCodec());
    }

    private static <E> Codec<List<Holder<E>>> holderListCodec(Codec<Holder<E>> holderCodec) {
        Function function = ExtraCodecs.ensureHomogenous(Holder::kind);
        Codec codec = holderCodec.listOf().flatXmap(function, function);
        return Codec.either((Codec)codec, holderCodec).xmap(either -> (List)either.map(p -> p, List::of), set -> set.size() == 1 ? Either.right((Object)((Holder)set.get(0))) : Either.left((Object)set));
    }

    public <T> DataResult<Pair<HolderSet<E>, T>> decode(DynamicOps<T> ops, T input) {
        return this.holderCodec.decode(ops, input).map(pair -> pair.mapFirst(either -> (HolderSet)either.map(arg_0 -> this.registry.getOrThrow(arg_0), HolderSet::direct)));
    }

    public <T> DataResult<T> encode(HolderSet<E> set, DynamicOps<T> ops, T prefix) {
        if (!set.canSerializeIn(this.registry)) {
            return DataResult.error(() -> "HolderSet " + String.valueOf(set) + " is not valid in current registry set");
        }
        return this.holderCodec.encode((Object)set.unwrap().mapRight(List::copyOf), ops, prefix);
    }
}

