/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.fluid;

import com.teamresourceful.resourcefullib.common.fluid.data.FluidData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourcefulBucketItem
extends BucketItem {
    private final FluidData data;

    public ResourcefulBucketItem(FluidData data, Item.Properties properties) {
        super((Fluid)data.still().get(), properties);
        this.data = data;
        this.data.setBucket(() -> this);
    }

    @NotNull
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (this.data.properties().canPlace()) {
            return super.use(level, player, hand);
        }
        return InteractionResult.FAIL;
    }

    protected void playEmptySound(@Nullable LivingEntity entity, LevelAccessor level, BlockPos pos) {
        SoundEvent event = this.data.properties().sounds().getOrDefault("bucket_empty", SoundEvents.BUCKET_EMPTY);
        level.playSound((Entity)entity, pos, event, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent((Entity)entity, (Holder)GameEvent.FLUID_PLACE, pos);
    }
}

