/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.nbt;

import com.teamresourceful.resourcefullib.common.nbt.NbtReader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class ObjectTagReader<I>
implements NbtReader<I, CompoundTag> {
    private final boolean defaultReaders;
    private final Map<String, NbtReader<I, ? extends Tag>> readers = new HashMap<String, NbtReader<I, ? extends Tag>>();

    public ObjectTagReader(boolean defaultReaders) {
        this.defaultReaders = defaultReaders;
    }

    public void addReader(String key, NbtReader<I, ? extends Tag> reader) {
        this.readers.put(key, reader);
    }

    @Override
    public byte type() {
        return 10;
    }

    @Override
    public void setDefault(I instance) {
        if (this.defaultReaders) {
            this.readers.forEach((key, reader) -> reader.setDefault(instance));
        }
    }

    @Override
    public void read(I instance, CompoundTag tag) {
        this.readers.forEach((key, reader) -> {
            Tag value = tag.get(key);
            if (value != null && value.getId() == reader.type()) {
                reader.castRead(instance, value);
            } else {
                reader.setDefault(instance);
            }
        });
    }

    @Override
    public CompoundTag write(I instance) {
        CompoundTag tag = new CompoundTag();
        this.write(instance, tag);
        return tag;
    }

    public void write(I instance, CompoundTag tag) {
        this.readers.forEach((key, reader) -> tag.put(key, reader.write(instance)));
    }
}

