/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.nbt.validators.numeric;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.codecs.CodecExtras;
import com.teamresourceful.resourcefullib.common.nbt.validators.numeric.NumericValidator;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;

public record BetweenNumericValidator(Optional<Number> min, Optional<Number> max) implements NumericValidator
{
    public static final String ID = "number:between";
    public static final Codec<BetweenNumericValidator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CodecExtras.NUMBER.optionalFieldOf("min").forGetter(BetweenNumericValidator::min), (App)CodecExtras.NUMBER.optionalFieldOf("max").forGetter(BetweenNumericValidator::max)).apply((Applicative)instance, BetweenNumericValidator::new));

    @Override
    public String id() {
        return ID;
    }

    @Override
    public boolean test(NumericTag tag) {
        NumericTag numericTag = tag;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ByteTag.class, ShortTag.class, IntTag.class, LongTag.class, FloatTag.class, DoubleTag.class}, (Object)numericTag, n)) {
            case 0 -> {
                ByteTag byteTag = (ByteTag)numericTag;
                byte min = this.min.map(Number::byteValue).orElse((byte)-128);
                byte max = this.max.map(Number::byteValue).orElse((byte)127);
                if (byteTag.value() >= min && byteTag.value() <= max) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                ShortTag shortTag = (ShortTag)numericTag;
                short min = this.min.map(Number::shortValue).orElse((short)Short.MIN_VALUE);
                short max = this.max.map(Number::shortValue).orElse((short)Short.MAX_VALUE);
                if (shortTag.value() >= min && shortTag.value() <= max) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                IntTag intTag = (IntTag)numericTag;
                int min = this.min.map(Number::intValue).orElse(Integer.MIN_VALUE);
                int max = this.max.map(Number::intValue).orElse(Integer.MAX_VALUE);
                if (intTag.value() >= min && intTag.value() <= max) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                LongTag longTag = (LongTag)numericTag;
                long min = this.min.map(Number::longValue).orElse(Long.MIN_VALUE);
                long max = this.max.map(Number::longValue).orElse(Long.MAX_VALUE);
                if (longTag.value() >= min && longTag.value() <= max) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                FloatTag floatTag = (FloatTag)numericTag;
                float min = this.min.map(Number::floatValue).orElse(Float.valueOf(Float.MIN_VALUE)).floatValue();
                float max = this.max.map(Number::floatValue).orElse(Float.valueOf(Float.MAX_VALUE)).floatValue();
                if (floatTag.value() >= min && floatTag.value() <= max) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                DoubleTag doubleTag = (DoubleTag)numericTag;
                double min = this.min.map(Number::doubleValue).orElse((Double)Double.MIN_VALUE);
                double max = this.max.map(Number::doubleValue).orElse((Double)Double.MAX_VALUE);
                if (doubleTag.value() >= min && doubleTag.value() <= max) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

