/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.registry.builtin;

import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistries;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistry;
import com.teamresourceful.resourcefullib.common.registry.builtin.base.ItemLikeEntry;
import com.teamresourceful.resourcefullib.common.registry.builtin.base.ItemLikeHolderEntry;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ResourcefulBlockRegistry
implements ResourcefulRegistry<Block> {
    private final String namespace;
    private final ResourcefulRegistry<Block> registry;

    public ResourcefulBlockRegistry(String id) {
        this(ResourcefulRegistries.create(BuiltInRegistries.BLOCK, id));
    }

    public ResourcefulBlockRegistry(ResourcefulRegistry<Block> parent) {
        this.namespace = Objects.requireNonNull(parent.namespace(), "Parent registry must have a namespace.");
        this.registry = parent;
    }

    public <I extends Block> ItemLikeEntry<I> register(String id, Function<BlockBehaviour.Properties, I> factory, Supplier<BlockBehaviour.Properties> getter) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)id));
        return this.register(id, () -> (Block)factory.apply(((BlockBehaviour.Properties)getter.get()).setId(key)));
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public <I extends Block> ItemLikeEntry<I> register(String id, Supplier<I> supplier) {
        return new ItemLikeEntry<I>(this.registry.register(id, supplier));
    }

    @Override
    public ItemLikeHolderEntry<Block> registerHolder(String id, Supplier<Block> supplier) {
        return new ItemLikeHolderEntry<Block>(this.registry.registerHolder(id, supplier));
    }

    @Override
    public Collection<RegistryEntry<Block>> getEntries() {
        return this.registry.getEntries();
    }

    @Override
    public void init() {
        this.registry.init();
    }
}

