/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.registry.builtin;

import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistries;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistry;
import com.teamresourceful.resourcefullib.common.registry.builtin.base.ItemLikeEntry;
import com.teamresourceful.resourcefullib.common.registry.builtin.base.ItemLikeHolderEntry;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ResourcefulItemRegistry
implements ResourcefulRegistry<Item> {
    private final String namespace;
    private final ResourcefulRegistry<Item> registry;

    public ResourcefulItemRegistry(String id) {
        this(ResourcefulRegistries.create(BuiltInRegistries.ITEM, id));
    }

    public ResourcefulItemRegistry(ResourcefulRegistry<Item> parent) {
        this.namespace = Objects.requireNonNull(parent.namespace(), "Parent registry must have a namespace.");
        this.registry = parent;
    }

    public <I extends Item> ItemLikeEntry<I> register(String id, Function<Item.Properties, I> factory, Supplier<Item.Properties> getter) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)id));
        return this.register(id, () -> (Item)factory.apply(((Item.Properties)getter.get()).setId(key)));
    }

    public ItemLikeEntry<BlockItem> register(String id, Supplier<? extends Block> supplier, Supplier<Item.Properties> getter) {
        return this.register(id, (Item.Properties properties) -> new BlockItem((Block)supplier.get(), properties.useBlockDescriptionPrefix()), getter);
    }

    @Override
    public String namespace() {
        return this.namespace;
    }

    @Override
    public <I extends Item> ItemLikeEntry<I> register(String id, Supplier<I> supplier) {
        return new ItemLikeEntry<I>(this.registry.register(id, supplier));
    }

    @Override
    public ItemLikeHolderEntry<Item> registerHolder(String id, Supplier<Item> supplier) {
        return new ItemLikeHolderEntry<Item>(this.registry.registerHolder(id, supplier));
    }

    @Override
    public Collection<RegistryEntry<Item>> getEntries() {
        return this.registry.getEntries();
    }

    @Override
    public void init() {
        this.registry.init();
    }
}

