/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.registry.neoforge;

import com.teamresourceful.resourcefullib.common.fluid.data.FluidData;
import com.teamresourceful.resourcefullib.common.fluid.data.FluidProperties;
import com.teamresourceful.resourcefullib.common.fluid.data.InternalFluidData;
import com.teamresourceful.resourcefullib.common.fluid.neoforge.ResourcefulFluidType;
import com.teamresourceful.resourcefullib.common.fluid.registry.ResourcefulFluidRegistry;
import com.teamresourceful.resourcefullib.common.registry.RegistryEntries;
import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class NeoForgeResourcefulFluidRegistry
implements ResourcefulFluidRegistry {
    private final String id;
    private final DeferredRegister<FluidType> registry;
    private final RegistryEntries<FluidData> entries = new RegistryEntries();

    public NeoForgeResourcefulFluidRegistry(String id) {
        this.id = id;
        this.registry = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)id);
    }

    @Override
    public String namespace() {
        return this.id;
    }

    @Override
    public RegistryEntry<FluidData> register(String name, FluidProperties properties) {
        ResourceLocation rid = ResourceLocation.fromNamespaceAndPath((String)this.id, (String)name);
        return this.entries.add(new ResourcefulFluidRegistry.Entry(rid, new InternalFluidData(rid, properties, (Supplier<?>)this.registry.register(name, id -> new ResourcefulFluidType((ResourceLocation)id, properties)))));
    }

    @Override
    public Collection<RegistryEntry<FluidData>> getEntries() {
        return this.entries.getEntries();
    }

    @Override
    public void init() {
        this.registry.register(ModLoadingContext.get().getActiveContainer().getEventBus());
    }
}

