/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils;

import com.google.gson.JsonElement;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericMemoryPack
implements PackResources {
    private final Map<ResourceLocation, IoSupplier<InputStream>> data = new HashMap<ResourceLocation, IoSupplier<InputStream>>();
    private final PackMetadataSection metaData;
    private final PackType allowedType;
    private final String id;
    private final PackLocationInfo info;

    protected GenericMemoryPack(PackType type, String id, PackMetadataSection meta) {
        this.metaData = meta;
        this.allowedType = type;
        this.id = id;
        this.info = new PackLocationInfo(id, CommonComponents.EMPTY, PackSource.BUILT_IN, Optional.empty());
    }

    private boolean isTypeAllowed(PackType type) {
        return this.allowedType.equals((Object)type);
    }

    public void putData(PackType type, ResourceLocation location, IoSupplier<InputStream> supplier) {
        if (!this.isTypeAllowed(type)) {
            return;
        }
        this.data.put(location, supplier);
    }

    public void putJson(PackType type, ResourceLocation location, JsonElement json) {
        this.putData(type, location, (IoSupplier<InputStream>)((IoSupplier)() -> new ByteArrayInputStream(Constants.GSON.toJson(json).getBytes(StandardCharsets.UTF_8))));
    }

    @Nullable
    public IoSupplier<InputStream> getRootResource(String ... files) {
        String file = String.join((CharSequence)"/", files);
        if (file.contains("/") || file.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        return null;
    }

    @Nullable
    public IoSupplier<InputStream> getResource(@NotNull PackType type, @NotNull ResourceLocation location) {
        if (!this.isTypeAllowed(type)) {
            return null;
        }
        return this.data.getOrDefault(location, null);
    }

    public void listResources(@NotNull PackType type, @NotNull String namespace, @NotNull String path, @NotNull PackResources.ResourceOutput output) {
        if (!this.isTypeAllowed(type)) {
            return;
        }
        this.data.entrySet().stream().filter(entry -> ((ResourceLocation)entry.getKey()).getNamespace().equals(namespace)).filter(entry -> ((ResourceLocation)entry.getKey()).getPath().startsWith(path)).forEach(entry -> output.accept((Object)((ResourceLocation)entry.getKey()), (Object)((IoSupplier)entry.getValue())));
    }

    @NotNull
    public Set<String> getNamespaces(@NotNull PackType type) {
        if (!this.isTypeAllowed(type)) {
            return Collections.emptySet();
        }
        return this.data.keySet().stream().map(ResourceLocation::getNamespace).collect(Collectors.toSet());
    }

    @Nullable
    public <T> T getMetadataSection(MetadataSectionType<T> type) {
        if (type.equals((Object)PackMetadataSection.TYPE)) {
            return (T)this.metaData;
        }
        return null;
    }

    @NotNull
    public String packId() {
        return this.id;
    }

    @NotNull
    public PackLocationInfo location() {
        return this.info;
    }

    public void close() {
        for (IoSupplier<InputStream> value : this.data.values()) {
            try {
                ((InputStream)value.get()).close();
            }
            catch (IOException e) {
                Constants.LOGGER.error("Failed to close input stream", (Throwable)e);
            }
        }
    }
}

