/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils.files;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.slf4j.Logger;

public final class CodecSavedData<T>
extends SavedData
implements Supplier<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Factory<T> factory;
    private T data;

    private CodecSavedData(Factory<T> factory, T data) {
        this.factory = factory;
        this.data = data;
    }

    private CodecSavedData(Factory<T> factory) {
        this.factory = factory;
        this.data = factory.defaultValue.get();
    }

    public boolean isDirty() {
        return this.factory.alwaysDirty || super.isDirty();
    }

    @Override
    public T get() {
        return this.data;
    }

    public void set(T data) {
        this.data = data;
        this.setDirty();
    }

    public static <T> Factory<T> create(Codec<T> codec, String path) {
        return new Factory<T>(codec, path);
    }

    public static class Factory<T> {
        private final Codec<T> codec;
        private final String path;
        private Supplier<T> defaultValue = () -> null;
        private boolean alwaysDirty = false;
        private boolean global = false;
        private SavedDataType<CodecSavedData<T>> type;

        private Factory(Codec<T> codec, String path) {
            this.codec = codec;
            this.path = path;
        }

        public Factory<T> defaultValue(Supplier<T> defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Factory<T> alwaysDirty() {
            this.alwaysDirty = true;
            return this;
        }

        public Factory<T> global() {
            this.global = true;
            return this;
        }

        public CodecSavedData<T> create(ServerLevel level) {
            DimensionDataStorage storage;
            DimensionDataStorage dimensionDataStorage = storage = this.global ? level.getServer().overworld().getDataStorage() : level.getDataStorage();
            if (this.type == null) {
                this.type = new SavedDataType(this.path, () -> new CodecSavedData(this), this.codec.xmap(data -> new CodecSavedData<Object>(this, data), data -> data.data), null);
            }
            return (CodecSavedData)storage.computeIfAbsent(this.type);
        }
    }
}

