/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.neoforge;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlagSet;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeResourcePackHandler {
    private static final List<ResourcePack> RESOURCE_PACKS = new ArrayList<ResourcePack>();
    private static final String RESOURCE_PACK_KEY = "resourcefullib:resourcepack";

    public static void load() {
        for (IModInfo mod : ModList.get().getMods()) {
            if (!mod.getModProperties().containsKey(RESOURCE_PACK_KEY)) continue;
            try {
                NeoForgeResourcePackHandler.initMod(mod, mod.getModProperties());
            }
            catch (Exception e) {
                Constants.LOGGER.error("Resourceful Lib failed to load resource pack for mod: " + mod.getDisplayName(), (Throwable)e);
            }
        }
    }

    private static void initMod(IModInfo mod, Map<String, Object> metadata) {
        for (Object pack : (List)metadata.get(RESOURCE_PACK_KEY)) {
            NeoForgeResourcePackHandler.loadPack(mod, pack);
        }
    }

    private static void loadPack(IModInfo mod, Object value) {
        if (value instanceof String) {
            String string = (String)value;
            RESOURCE_PACKS.add(new ResourcePack(mod, string, null, false));
        } else if (value instanceof UnmodifiableConfig) {
            UnmodifiableConfig config = (UnmodifiableConfig)value;
            Map map = config.valueMap();
            String name = (String)NeoForgeResourcePackHandler.getOrThrow(map, "name");
            String description = (String)map.get("description");
            boolean required = map.getOrDefault("required", false);
            RESOURCE_PACKS.add(new ResourcePack(mod, name, description, required));
        }
    }

    private static <T> T getOrThrow(Map<?, ?> map, String id) {
        if (!map.containsKey(id)) {
            throw new IllegalStateException("Missing key: " + id);
        }
        return (T)map.get(id);
    }

    public static void onRegisterPackFinders(AddPackFindersEvent event) {
        for (ResourcePack resourcePack : RESOURCE_PACKS) {
            try {
                Path path = resourcePack.mod().getOwningFile().getFile().findResource(new String[]{"resourcepacks/" + resourcePack.name()});
                if (!Files.isDirectory(path.resolve(event.getPackType().getDirectory()), new LinkOption[0])) continue;
                String id = ResourceLocation.fromNamespaceAndPath((String)resourcePack.mod().getModId(), (String)resourcePack.name()).toString();
                PathPackResources.PathResourcesSupplier supplier = new PathPackResources.PathResourcesSupplier(path);
                PackLocationInfo locationInfo = new PackLocationInfo(id, NeoForgeResourcePackHandler.createDescription(resourcePack.description(), resourcePack.name()), PackSource.create((UnaryOperator)PackSource.NO_DECORATION, (boolean)resourcePack.required()), Optional.empty());
                Pack.Metadata info = NeoForgeResourcePackHandler.getInfo(locationInfo, (Pack.ResourcesSupplier)supplier, event.getPackType(), resourcePack.required());
                PackSelectionConfig config = new PackSelectionConfig(resourcePack.required(), Pack.Position.TOP, false);
                Pack pack = new Pack(locationInfo, (Pack.ResourcesSupplier)supplier, info, config);
                event.addRepositorySource(source -> source.accept(pack));
            }
            catch (Exception ignored) {
                Constants.LOGGER.error("Resourceful Lib failed to init resource pack for mod: " + resourcePack.mod().getDisplayName());
            }
        }
    }

    private static Pack.Metadata getInfo(PackLocationInfo locationInfo, Pack.ResourcesSupplier supplier, PackType type, boolean hidden) {
        Pack.Metadata info;
        if (!hidden && (info = Pack.readPackMetadata((PackLocationInfo)locationInfo, (Pack.ResourcesSupplier)supplier, (int)SharedConstants.getCurrentVersion().packVersion(type))) != null) {
            return info;
        }
        return new Pack.Metadata(CommonComponents.EMPTY, PackCompatibility.COMPATIBLE, FeatureFlagSet.of(), List.of(), hidden);
    }

    private static Component createDescription(@Nullable String description, String name) {
        if (description != null) {
            return Component.literal((String)description);
        }
        return Component.translatableWithFallback((String)("resourcefullib.resourcepack." + name), (String)name);
    }

    private record ResourcePack(IModInfo mod, String name, @Nullable String description, boolean required) {
    }
}

