/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.neoforge;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.teamresourceful.resourcefullib.client.fluid.data.ClientFluidProperties;
import com.teamresourceful.resourcefullib.client.fluid.neoforge.ResourcefulClientFluidType;
import com.teamresourceful.resourcefullib.client.fluid.registry.ResourcefulClientFluidRegistry;
import com.teamresourceful.resourcefullib.client.highlights.HighlightHandler;
import com.teamresourceful.resourcefullib.client.sysinfo.SystemInfo;
import com.teamresourceful.resourcefullib.common.fluid.neoforge.ResourcefulFluidType;
import com.teamresourceful.resourcefullib.neoforge.NeoForgeResourcePackHandler;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ResourcefulLibNeoForgeClient {
    public static void init(IEventBus modEventBus) {
        NeoForgeResourcePackHandler.load();
        NeoForge.EVENT_BUS.addListener(ResourcefulLibNeoForgeClient::onHighlight);
        NeoForge.EVENT_BUS.addListener(ResourcefulLibNeoForgeClient::onClientCommandRegister);
        modEventBus.addListener(ResourcefulLibNeoForgeClient::onRegisterFluidClient);
        modEventBus.addListener(ResourcefulLibNeoForgeClient::onClientReloadListeners);
        modEventBus.addListener(NeoForgeResourcePackHandler::onRegisterPackFinders);
    }

    public static void onClientReloadListeners(AddClientReloadListenersEvent event) {
        event.addListener(ResourceLocation.fromNamespaceAndPath((String)"resourcefullib", (String)"highlights"), (PreparableReloadListener)new HighlightHandler());
    }

    public static void onHighlight(RenderHighlightEvent.Block event) {
        BlockState state = event.getCamera().getEntity().level().getBlockState(event.getTarget().getBlockPos());
        int color = (Boolean)Minecraft.getInstance().options.highContrastBlockOutline().get() != false ? -11010079 : ARGB.color((int)102, (int)-16777216);
        event.setCanceled(HighlightHandler.onBlockHighlight(event.getCamera().getPosition(), event.getCamera().getEntity(), event.getPoseStack(), event.getTarget().getBlockPos(), state, event.getMultiBufferSource().getBuffer(RenderType.lines()), color));
    }

    public static void onClientCommandRegister(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"rlib").then(Commands.literal((String)"info").executes(context -> {
            String info = SystemInfo.buildForDiscord();
            Minecraft.getInstance().keyboardHandler.setClipboard(info);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"[Resourceful Lib]: Info copied to clipboard!"));
            return 1;
        })));
    }

    public static void onRegisterFluidClient(RegisterClientExtensionsEvent event) {
        for (Map.Entry entry : NeoForgeRegistries.FLUID_TYPES.entrySet()) {
            ClientFluidProperties properties;
            ResourceLocation id = ((ResourceKey)entry.getKey()).location();
            FluidType type = (FluidType)entry.getValue();
            if (!(type instanceof ResourcefulFluidType) || (properties = ResourcefulClientFluidRegistry.get(id)) == null) continue;
            event.registerFluidType((IClientFluidTypeExtensions)new ResourcefulClientFluidType(properties), new FluidType[]{type});
        }
    }
}

