/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.loot;

import com.autovw.advancednetherite.common.item.AdvancedHoeItem;
import com.autovw.advancednetherite.config.ConfigHelper;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class CropDropsLootModifier
extends LootModifier {
    public static final MapCodec<CropDropsLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> CropDropsLootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CropDropsLootModifier::new));

    public CropDropsLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        ItemStack tool = (ItemStack)context.getOptionalParameter(LootContextParams.TOOL);
        BlockState blockState = (BlockState)context.getOptionalParameter(LootContextParams.BLOCK_STATE);
        if (tool != null && blockState != null && ConfigHelper.get().getCommon().getAdditionalDrops().enableAdditionalCropDrops()) {
            CropBlock cropBlock;
            if (!(tool.getItem() instanceof AdvancedHoeItem)) {
                return generatedLoot;
            }
            Block block = blockState.getBlock();
            if (block instanceof CropBlock && (cropBlock = (CropBlock)block).isMaxAge(blockState)) {
                RandomSource random = context.getRandom();
                if (cropBlock == Blocks.WHEAT && (double)random.nextFloat() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalWheatDropChance()) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.WHEAT, random.nextIntBetweenInclusive(0, 2)));
                }
                if (cropBlock == Blocks.CARROTS && (double)random.nextFloat() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalCarrotsDropChance()) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.CARROT, random.nextIntBetweenInclusive(0, 2)));
                }
                if (cropBlock == Blocks.POTATOES && (double)random.nextFloat() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalPotatoesDropChance()) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.POTATO, random.nextIntBetweenInclusive(0, 1)));
                }
                if (cropBlock == Blocks.BEETROOTS && (double)random.nextFloat() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalBeetrootsDropChance()) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.BEETROOT, random.nextIntBetweenInclusive(1, 2)));
                }
            }
        }
        return generatedLoot;
    }

    public MapCodec<CropDropsLootModifier> codec() {
        return CODEC;
    }
}

