/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.common.loot;

import com.autovw.advancednetherite.config.ConfigHelper;
import com.autovw.advancednetherite.core.util.ModTags;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class MobDropsLootModifier
extends LootModifier {
    public static final MapCodec<MobDropsLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> MobDropsLootModifier.codecStart((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, MobDropsLootModifier::new));

    public MobDropsLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Entity attacker = (Entity)context.getOptionalParameter(LootContextParams.ATTACKING_ENTITY);
        Entity victim = (Entity)context.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (victim != null && ConfigHelper.get().getCommon().getAdditionalDrops().enableAdditionalMobDrops()) {
                ItemStack useItem = player.getMainHandItem();
                RandomSource random = context.getRandom();
                if (useItem.is(ModTags.DROPS_ADDITIONAL_PHANTOM_LOOT) && victim.getType() == EntityType.PHANTOM && (double)random.nextFloat() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalPhantomDropChance()) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.PHANTOM_MEMBRANE, random.nextIntBetweenInclusive(0, 2)));
                }
                if (useItem.is(ModTags.DROPS_ADDITIONAL_ZOMBIFIED_PIGLIN_LOOT) && victim.getType() == EntityType.ZOMBIFIED_PIGLIN && (double)random.nextFloat() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalZombifiedPiglinDropChance()) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.GOLD_NUGGET, random.nextIntBetweenInclusive(0, 3)));
                }
                if (useItem.is(ModTags.DROPS_ADDITIONAL_PIGLIN_LOOT) && victim.getType() == EntityType.PIGLIN && (double)random.nextFloat() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalPiglinDropChance()) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.GOLD_INGOT, random.nextIntBetweenInclusive(1, 1)));
                }
                if (useItem.is(ModTags.DROPS_ADDITIONAL_ENDERMAN_LOOT) && victim.getType() == EntityType.ENDERMAN && (double)random.nextFloat() <= ConfigHelper.get().getServer().getAdditionalDropProperties().getAdditionalEndermanDropChance()) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.ENDER_PEARL, random.nextIntBetweenInclusive(0, 1)));
                }
            }
        }
        return generatedLoot;
    }

    public MapCodec<MobDropsLootModifier> codec() {
        return CODEC;
    }
}

