/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.mgen256.al.AdditionalLights;
import com.mgen256.al.FireTypes;
import com.mgen256.al.ModBlockList;
import com.mgen256.al.blocks.IHasFire;
import com.mgen256.al.blocks.IModBlock;
import com.mgen256.al.items.SoulWand;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ALTorch
extends TorchBlock
implements IModBlock,
IHasFire {
    protected static final VoxelShape SHAPE = Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)10.0, (double)10.5);
    private ModBlockList myKey;
    private String name;

    public static BlockBehaviour.Properties createProps(Block mainblock, String name) {
        return BlockBehaviour.Properties.of().noCollission().instabreak().lightLevel(lightLevel -> 14).sound(mainblock.defaultBlockState().getSoundType()).setId(AdditionalLights.createResourceKey(name));
    }

    public ALTorch(Block mainblock, String name) {
        super(ParticleTypes.FLAME, ALTorch.createProps(mainblock, name));
        this.name = name;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FIRE_TYPE, (Comparable)((Object)FireTypes.NORMAL))).setValue((Property)PREVIOUS_FIRE_TYPE, (Comparable)((Object)FireTypes.NORMAL)));
    }

    @Override
    public void setMyKey(ModBlockList key) {
        this.myKey = key;
    }

    @Override
    public String getRegName() {
        return this.name;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FIRE_TYPE});
        builder.add(new Property[]{PREVIOUS_FIRE_TYPE});
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return state.getValue((Property)FIRE_TYPE) == FireTypes.SOUL ? 10 : 14;
    }

    public VoxelShape getShape(BlockState p_57510_, BlockGetter p_57511_, BlockPos p_57512_, CollisionContext p_57513_) {
        return SHAPE;
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + 0.7;
        double d2 = (double)pos.getZ() + 0.5;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
        SimpleParticleType particleOption = stateIn.getValue((Property)FIRE_TYPE) == FireTypes.SOUL ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME;
        level.addParticle((ParticleOptions)particleOption, d0, d1, d2, 0.0, 0.0, 0.0);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)this.myKey.getBlockItem()));
        return list;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer == null) {
            return;
        }
        if (placer.getOffhandItem().getItem() instanceof SoulWand) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FIRE_TYPE, (Comparable)((Object)FireTypes.SOUL)));
        }
    }
}

