/*
 * Decompiled with CFR 0.152.
 */
package com.mgen256.al.blocks;

import com.google.common.collect.Maps;
import com.mgen256.al.FireTypes;
import com.mgen256.al.ModBlockList;
import com.mgen256.al.blocks.ALTorch;
import com.mgen256.al.blocks.IHasFire;
import com.mgen256.al.blocks.IModBlock;
import com.mgen256.al.items.SoulWand;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ALTorch_Wall
extends WallTorchBlock
implements IModBlock,
IHasFire {
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap(Map.of(Direction.NORTH, Block.box((double)5.5, (double)2.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), Direction.SOUTH, Block.box((double)5.5, (double)2.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), Direction.WEST, Block.box((double)11.0, (double)2.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), Direction.EAST, Block.box((double)0.0, (double)2.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));
    private ModBlockList floorKey;
    private ModBlockList myKey;
    private String name;

    public ALTorch_Wall(Block mainblock, ModBlockList _floorKey, String name) {
        super(ParticleTypes.FLAME, ALTorch.createProps(mainblock, name));
        this.floorKey = _floorKey;
        this.name = name;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)FIRE_TYPE, (Comparable)((Object)FireTypes.NORMAL))).setValue((Property)PREVIOUS_FIRE_TYPE, (Comparable)((Object)FireTypes.NORMAL)));
    }

    @Override
    public void setMyKey(ModBlockList key) {
        this.myKey = key;
    }

    @Override
    public String getRegName() {
        return this.name;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FIRE_TYPE});
        builder.add(new Property[]{PREVIOUS_FIRE_TYPE});
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return state.getValue((Property)FIRE_TYPE) == FireTypes.SOUL ? 10 : 14;
    }

    public VoxelShape getShape(BlockState p_58152_, BlockGetter p_58153_, BlockPos p_58154_, CollisionContext p_58155_) {
        return ALTorch_Wall.getShape(p_58152_);
    }

    public static VoxelShape getShape(BlockState p_58157_) {
        return SHAPES.get(p_58157_.getValue((Property)FACING));
    }

    public void animateTick(BlockState stateIn, Level level, BlockPos pos, RandomSource rand) {
        Direction direction = (Direction)stateIn.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        double dx = (double)pos.getX() + 0.5;
        double dy = (double)pos.getY() + 0.9;
        double dz = (double)pos.getZ() + 0.5;
        Direction direction1 = direction.getOpposite();
        double d3 = 0.38;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, dx + d3 * (double)direction1.getStepX(), dy, dz + d3 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
        SimpleParticleType particleOption = stateIn.getValue((Property)FIRE_TYPE) == FireTypes.SOUL ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME;
        level.addParticle((ParticleOptions)particleOption, dx + d3 * (double)direction1.getStepX(), dy, dz + d3 * (double)direction1.getStepZ(), 0.0, 0.0, 0.0);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)this.floorKey.getBlockItem()));
        return list;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer.getOffhandItem().getItem() instanceof SoulWand) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FIRE_TYPE, (Comparable)((Object)FireTypes.SOUL)));
        }
    }
}

