/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads;

import java.util.List;
import java.util.Random;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.config.reflection.Comment;
import net.blay09.mods.balm.api.config.reflection.Config;
import net.blay09.mods.balm.api.config.reflection.NestedType;

@Config(value="farmingforblockheads")
public class FarmingForBlockheadsConfig {
    public static final Set<String> DEFAULT_INCLUDED_GROUPS = Set.of("selling.seeds", "selling.saplings", "selling.fertilizers.minecraft");
    public static final List<String> DEFAULT_MERCHANT_NAMES = List.of("Swap-O-Matic", "Emerald Muncher", "Weathered Salesperson");
    @Comment(value="List of groups to enable. 'default' is an alias for the inbuilt defaults (selling.seeds, selling.saplings and selling.fertilizers.minecraft).")
    @NestedType(value=String.class)
    public Set<String> includedGroups = Set.of("default");
    @Comment(value="List of groups to disable. Has precedence over includedGroups. 'selling.seeds' for example would disable all seeds from the market.")
    @NestedType(value=String.class)
    public Set<String> excludedGroups = Set.of();
    @NestedType(value=String.class)
    @Comment(value="List of names the merchant can have.")
    public List<String> merchantNames = DEFAULT_MERCHANT_NAMES;
    @Comment(value="The range within animals can be fed by the feeding trough.")
    public int feedingTroughRange = 8;
    @Comment(value="The maximum amount of animals (per type) until the feeding trough stops feeding.")
    public int feedingTroughMaxAnimals = 24;
    @Comment(value="The range at which the chicken nest picks up laid eggs.")
    public int chickenNestRange = 8;
    @Comment(value="The chance to get a bonus crop when using Green Fertilizer.")
    public double fertilizerBonusCropChance = 1.0;
    @Comment(value="The chance to get a bonus growth when using Red Fertilizer.")
    public double fertilizerBonusGrowthChance = 1.0;
    @Comment(value="The chance for Fertilized Farmland to turn back into regular Farmland (per provided bonus).")
    public double fertilizerRegressionChance = 0.0;
    @Comment(value="If true, merchants will be considered babies (on a technical level only), which may resolve exploits based on merchant death loot (like blood)")
    public boolean treatMerchantsLikeBabies = true;

    public String getRandomMerchantName(Random rand) {
        List<String> candidates = this.merchantNames;
        if (candidates.isEmpty()) {
            candidates = DEFAULT_MERCHANT_NAMES;
        }
        return candidates.get(rand.nextInt(candidates.size()));
    }

    public static FarmingForBlockheadsConfig getActive() {
        return (FarmingForBlockheadsConfig)Balm.getConfig().getActiveConfig(FarmingForBlockheadsConfig.class);
    }

    public static void initialize() {
        Balm.getConfig().registerConfig(FarmingForBlockheadsConfig.class);
    }
}

