/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.block.entity;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.tag.BalmItemTags;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheadsConfig;
import net.blay09.mods.farmingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.farmingforblockheads.network.ChickenNestEffectMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;

public class ChickenNestBlockEntity
extends BalmBlockEntity
implements BalmContainerProvider {
    private static final int TICK_INTERVAL = 20;
    private final DefaultContainer container = new DefaultContainer(1){

        public boolean canPlaceItem(int i, ItemStack itemStack) {
            return ChickenNestBlockEntity.this.isEggItem(itemStack);
        }

        public void setChanged() {
            ChickenNestBlockEntity.this.isDirty = true;
            ChickenNestBlockEntity.this.setChanged();
        }

        public int getMaxStackSize() {
            return 4;
        }
    };
    private int tickTimer;
    private boolean isDirty;

    public ChickenNestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.chickenNest.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ChickenNestBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        ++this.tickTimer;
        if (this.tickTimer >= 20) {
            this.stealEgg();
            this.tickTimer = 0;
        }
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
    }

    protected void loadAdditional(ValueInput input) {
        input.child("ItemHandler").ifPresent(it -> ContainerHelper.loadAllItems((ValueInput)it, (NonNullList)this.container.getItems()));
    }

    public void saveAdditional(ValueOutput output) {
        ContainerHelper.saveAllItems((ValueOutput)output.child("ItemHandler"), (NonNullList)this.container.getItems());
    }

    public void writeUpdateTag(ValueOutput output) {
        this.saveAdditional(output);
    }

    private void stealEgg() {
        float range = FarmingForBlockheadsConfig.getActive().chickenNestRange;
        AABB aabb = new AABB((double)((float)this.worldPosition.getX() - range), (double)((float)this.worldPosition.getY() - range), (double)((float)this.worldPosition.getZ() - range), (double)((float)this.worldPosition.getX() + range), (double)((float)this.worldPosition.getY() + range), (double)((float)this.worldPosition.getZ() + range));
        List list = this.level.getEntitiesOfClass(ItemEntity.class, aabb, p -> p != null && this.isEggItem(p.getItem()));
        if (list.isEmpty()) {
            return;
        }
        ItemEntity entityItem = (ItemEntity)list.get(0);
        ItemStack originalStack = entityItem.getItem();
        ItemStack restStack = entityItem.getItem().copy();
        for (int i = 0; i < this.container.getContainerSize() && !(restStack = ContainerUtils.insertItem((Container)this.container, (int)i, (ItemStack)restStack, (boolean)false)).isEmpty(); ++i) {
        }
        if (restStack.isEmpty()) {
            entityItem.remove(Entity.RemovalReason.DISCARDED);
        } else {
            entityItem.setItem(restStack);
        }
        if (restStack.isEmpty() || restStack.getCount() != originalStack.getCount()) {
            Balm.getNetworking().sendToTracking((ServerLevel)this.level, this.worldPosition, (CustomPacketPayload)new ChickenNestEffectMessage(this.worldPosition));
        }
        this.setChanged();
    }

    private boolean isEggItem(ItemStack item) {
        return item.is(BalmItemTags.EGGS);
    }

    public int getEggCount() {
        return this.container.getItem(0).getCount();
    }

    public Container getContainer() {
        return this.container;
    }
}

