/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.gui.screen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.balm.mixin.ScreenAccessor;
import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.client.gui.widget.MarketFilterButton;
import net.blay09.mods.farmingforblockheads.menu.MarketListingSlot;
import net.blay09.mods.farmingforblockheads.menu.MarketMenu;
import net.blay09.mods.farmingforblockheads.mixin.GhostSlotsAccessor;
import net.blay09.mods.farmingforblockheads.recipe.MarketRecipeDisplay;
import net.blay09.mods.farmingforblockheads.registry.SimpleHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.GhostSlots;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;

public class MarketScreen
extends AbstractContainerScreen<MarketMenu>
implements RecipeUpdateListener {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final int VISIBLE_ROWS = 4;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"farmingforblockheads", (String)"textures/gui/market.png");
    private final List<MarketFilterButton> filterButtons = new ArrayList<MarketFilterButton>();
    private float time;
    private final GhostSlots ghostSlots = new GhostSlots(() -> Mth.floor((float)(this.time / 30.0f)));
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private int mouseClickY = -1;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private EditBox searchBar;

    public MarketScreen(MarketMenu container, Inventory playerInventory, Component displayName) {
        super((AbstractContainerMenu)container, playerInventory, displayName);
    }

    public void init() {
        this.imageHeight = 174;
        super.init();
        Font font = Minecraft.getInstance().font;
        this.searchBar = new EditBox(font, this.leftPos + this.imageWidth - 78, this.topPos - 5, 70, 10, this.searchBar, (Component)Component.empty());
        this.setInitialFocus((GuiEventListener)this.searchBar);
        this.addRenderableWidget((GuiEventListener)this.searchBar);
        this.updateCategoryFilters();
        this.recalculateScrollBar();
    }

    private void updateCategoryFilters() {
        for (MarketFilterButton filterButton : this.filterButtons) {
            ((ScreenAccessor)this).balm_getChildren().remove((Object)filterButton);
            ((ScreenAccessor)this).balm_getRenderables().remove((Object)filterButton);
            ((ScreenAccessor)this).balm_getNarratables().remove((Object)filterButton);
        }
        this.filterButtons.clear();
        int curX = 87;
        int curY = -80;
        List<SimpleHolder<MarketCategory>> categories = ((MarketMenu)this.menu).getCategories();
        for (SimpleHolder<MarketCategory> category : categories) {
            MarketFilterButton filterButton = new MarketFilterButton(this.width / 2 + curX, this.height / 2 + curY, (MarketMenu)this.menu, category, button -> {
                if (((MarketMenu)this.menu).getCurrentCategory().map(it -> it.equals(category)).orElse(false).booleanValue()) {
                    ((MarketMenu)this.menu).setCategory(null);
                } else {
                    ((MarketMenu)this.menu).setCategory(category);
                }
                ((MarketMenu)this.menu).updateListingSlots();
                this.setCurrentOffset(this.currentOffset);
            });
            this.addRenderableWidget((GuiEventListener)filterButton);
            this.filterButtons.add(filterButton);
            if ((curY += 20) <= 60) continue;
            curY = -80;
            curX += 20;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (Math.abs(deltaY) > 0.0) {
            this.setCurrentOffset(deltaY > 0.0 ? this.currentOffset - 1 : this.currentOffset + 1);
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1 && mouseX >= (double)this.searchBar.getX() && mouseX < (double)(this.searchBar.getX() + this.searchBar.getWidth()) && mouseY >= (double)this.searchBar.getY() && mouseY < (double)(this.searchBar.getY() + this.searchBar.getHeight())) {
            this.searchBar.setValue("");
            ((MarketMenu)this.menu).setSearch(null);
            ((MarketMenu)this.menu).updateListingSlots();
            this.setCurrentOffset(this.currentOffset);
            return true;
        }
        if (mouseX >= (double)this.scrollBarXPos && mouseX <= (double)(this.scrollBarXPos + 7) && mouseY >= (double)this.scrollBarYPos && mouseY <= (double)(this.scrollBarYPos + this.scrollBarScaledHeight)) {
            this.mouseClickY = (int)mouseY;
            this.indexWhenClicked = this.currentOffset;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean charTyped(char c, int keyCode) {
        boolean result = super.charTyped(c, keyCode);
        ((MarketMenu)this.menu).setSearch(this.searchBar.getValue());
        ((MarketMenu)this.menu).updateListingSlots();
        this.setCurrentOffset(this.currentOffset);
        return result;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.searchBar.keyPressed(keyCode, scanCode, modifiers) || this.searchBar.isFocused()) {
            if (keyCode == 256) {
                this.minecraft.player.closeContainer();
            } else {
                ((MarketMenu)this.menu).setSearch(this.searchBar.getValue());
                ((MarketMenu)this.menu).updateListingSlots();
                this.setCurrentOffset(this.currentOffset);
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (!Screen.hasControlDown()) {
            this.time += partialTicks;
        }
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (((MarketMenu)this.menu).isScrollOffsetDirty()) {
            this.updateCategoryFilters();
            this.recalculateScrollBar();
            ((MarketMenu)this.menu).setScrollOffsetDirty(false);
        }
        Font font = this.minecraft.font;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos - 10, 0.0f, 0.0f, this.imageWidth, this.imageHeight + 10, 256, 256);
        if (this.mouseClickY != -1 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)((MarketMenu)this.menu).getFilteredListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        guiGraphics.drawString(font, I18n.get((String)"container.farmingforblockheads.market", (Object[])new Object[0]), this.leftPos + 10, this.topPos + 10, 0xFFFFFF, true);
        guiGraphics.fill(this.scrollBarXPos, this.scrollBarYPos, this.scrollBarXPos + 7, this.scrollBarYPos + this.scrollBarScaledHeight, -5592406);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int x, int y) {
    }

    protected void renderSlots(GuiGraphics guiGraphics) {
        super.renderSlots(guiGraphics);
        this.ghostSlots.render(guiGraphics, this.minecraft, false);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        this.ghostSlots.renderTooltip(guiGraphics, this.minecraft, x, y, this.hoveredSlot);
    }

    protected void slotClicked(Slot slot, int pSlotId, int pMouseButton, ClickType pType) {
        super.slotClicked(slot, pSlotId, pMouseButton, pType);
        if (slot == ((MarketMenu)this.menu).getResultSlot() || slot == ((MarketMenu)this.menu).getPaymentSlot() || slot instanceof MarketListingSlot) {
            this.ghostSlots.clear();
        }
    }

    public Collection<MarketFilterButton> getFilterButtons() {
        return this.filterButtons;
    }

    private void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)((MarketMenu)this.menu).getFilteredListCount() / 3.0f)));
        this.scrollBarXPos = this.leftPos + this.imageWidth - 7 - 9;
        this.scrollBarYPos = this.topPos + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)((MarketMenu)this.menu).getFilteredListCount() / 3.0f) - 4);
    }

    private void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)((MarketMenu)this.menu).getFilteredListCount() / 3.0f) - 4));
        ((MarketMenu)this.menu).setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    public void recipesUpdated() {
    }

    public void fillGhostRecipe(RecipeDisplay recipeDisplay) {
        this.ghostSlots.clear();
        ClientLevel level = Minecraft.getInstance().level;
        ContextMap contextMap = SlotDisplayContext.fromLevel((Level)level);
        GhostSlots ghostSlots = this.ghostSlots;
        if (ghostSlots instanceof GhostSlotsAccessor) {
            GhostSlotsAccessor accessor = (GhostSlotsAccessor)ghostSlots;
            accessor.callSetResult(((MarketMenu)this.menu).getResultSlot(), contextMap, recipeDisplay.result());
            if (recipeDisplay instanceof MarketRecipeDisplay) {
                MarketRecipeDisplay marketRecipeDisplay = (MarketRecipeDisplay)recipeDisplay;
                accessor.callSetSlot(((MarketMenu)this.menu).getPaymentSlot(), contextMap, marketRecipeDisplay.payment(), true);
            }
        }
    }
}

