/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.item;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.blay09.mods.farmingforblockheads.block.FertilizedFarmlandBlock;
import net.blay09.mods.farmingforblockheads.block.ModBlocks;
import net.blay09.mods.farmingforblockheads.tag.ModBlockTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class FertilizerItem
extends Item {
    private final FertilizerType fertilizerType;

    public FertilizerItem(Item.Properties properties, FertilizerType fertilizerType) {
        super(properties);
        this.fertilizerType = fertilizerType;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        ItemStack heldItem = context.getItemInHand();
        if (this.tryApplyFertilizerAt(level, pos) || this.tryApplyFertilizerAt(level, pos.below())) {
            if (!player.getAbilities().instabuild) {
                heldItem.shrink(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    private boolean tryApplyFertilizerAt(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        BlockState newState = this.fertilizerType.applyFertilizer(state);
        if (newState != state) {
            world.setBlockAndUpdate(pos, newState);
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> tooltip, TooltipFlag flag) {
        tooltip.accept(this.fertilizerType.getTooltip());
    }

    public static enum FertilizerType {
        HEALTHY((Component)Component.translatable((String)"tooltip.farmingforblockheads.red_fertilizer").withStyle(ChatFormatting.DARK_RED)),
        RICH((Component)Component.translatable((String)"tooltip.farmingforblockheads.green_fertilizer").withStyle(ChatFormatting.GREEN)),
        STABLE((Component)Component.translatable((String)"tooltip.farmingforblockheads.yellow_fertilizer").withStyle(ChatFormatting.YELLOW));

        private final Component tooltip;

        private FertilizerType(Component tooltip) {
            this.tooltip = tooltip;
        }

        public Component getTooltip() {
            return this.tooltip;
        }

        public boolean canFertilize(BlockState state) {
            Block sourceBlock = state.getBlock();
            return sourceBlock == Blocks.FARMLAND || sourceBlock instanceof FertilizedFarmlandBlock;
        }

        public BlockState applyFertilizer(BlockState state) {
            Block targetBlock;
            if (!this.canFertilize(state)) {
                return state;
            }
            int moisture = (Integer)state.getValue((Property)BlockStateProperties.MOISTURE);
            HashSet<FertilizerType> traits = new HashSet<FertilizerType>();
            traits.add(this);
            if (state.is(ModBlockTags.HEALTHY_FARMLAND)) {
                traits.add(HEALTHY);
            }
            if (state.is(ModBlockTags.RICH_FARMLAND)) {
                traits.add(RICH);
            }
            if (state.is(ModBlockTags.STABLE_FARMLAND)) {
                traits.add(STABLE);
            }
            if ((targetBlock = FertilizerType.getBlockForTraits(traits)) == null) {
                return state;
            }
            BlockState newState = targetBlock.defaultBlockState();
            return (BlockState)newState.setValue((Property)FertilizedFarmlandBlock.MOISTURE, (Comparable)Integer.valueOf(moisture));
        }

        @Nullable
        private static Block getBlockForTraits(Set<FertilizerType> traits) {
            boolean hasStableTrait = traits.contains((Object)STABLE);
            boolean hasHealthyTrait = traits.contains((Object)HEALTHY);
            boolean hasRichTrait = traits.contains((Object)RICH);
            if (hasStableTrait && !hasRichTrait && !hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandStable;
            }
            if (!hasStableTrait && hasRichTrait && !hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandRich;
            }
            if (!hasStableTrait && !hasRichTrait && hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandHealthy;
            }
            if (hasStableTrait && hasRichTrait && !hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandRichStable;
            }
            if (hasStableTrait && !hasRichTrait && hasHealthyTrait) {
                return ModBlocks.fertilizedFarmlandHealthyStable;
            }
            return null;
        }
    }
}

