/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.menu;

import java.util.List;
import net.blay09.mods.farmingforblockheads.menu.MarketPaymentContainer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MarketResultSlot
extends Slot {
    private final MarketPaymentContainer paymentSlots;
    private final Player player;
    private int removeCount;

    public MarketResultSlot(Player player, MarketPaymentContainer paymentSlots, Container container, int index, int xPosition, int yPosition) {
        super(container, index, xPosition, yPosition);
        this.player = player;
        this.paymentSlots = paymentSlots;
    }

    public boolean mayPlace(ItemStack stack) {
        return false;
    }

    public ItemStack remove(int amount) {
        if (this.hasItem()) {
            this.removeCount += Math.min(amount, this.getItem().getCount());
        }
        return super.remove(amount);
    }

    protected void onQuickCraft(ItemStack itemStack, int amount) {
        this.removeCount += amount;
        this.checkTakeAchievements(itemStack);
    }

    protected void onSwapCraft(int itemsCrafted) {
        this.removeCount += itemsCrafted;
    }

    protected void checkTakeAchievements(ItemStack itemStack) {
        Container container;
        if (this.removeCount > 0) {
            itemStack.onCraftedBy(this.player, this.removeCount);
        }
        if ((container = this.container) instanceof RecipeCraftingHolder) {
            RecipeCraftingHolder recipeCraftingHolder = (RecipeCraftingHolder)container;
            recipeCraftingHolder.awardUsedRecipes(this.player, (List)this.paymentSlots.getItems());
        }
        this.removeCount = 0;
    }

    public void onTake(Player player, ItemStack itemStack) {
        this.checkTakeAchievements(itemStack);
        ItemStack remainingStack = ItemStack.EMPTY;
        boolean paymentSlot = false;
        ItemStack paymentStack = this.paymentSlots.getItem(0);
        if (!paymentStack.isEmpty()) {
            this.paymentSlots.removePayment(0);
            paymentStack = this.paymentSlots.getItem(0);
        }
        if (!remainingStack.isEmpty()) {
            if (paymentStack.isEmpty()) {
                this.paymentSlots.setItem(0, remainingStack);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)paymentStack, (ItemStack)remainingStack)) {
                remainingStack.grow(paymentStack.getCount());
                this.paymentSlots.setItem(0, remainingStack);
            } else if (!player.getInventory().add(remainingStack)) {
                player.drop(remainingStack, false);
            }
        }
    }

    public boolean isFake() {
        return true;
    }
}

