/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.network;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.api.MarketCategory;
import net.blay09.mods.farmingforblockheads.menu.MarketMenu;
import net.blay09.mods.farmingforblockheads.registry.MarketCategoryImpl;
import net.blay09.mods.farmingforblockheads.registry.SimpleHolder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public record MarketCategoriesMessage(List<SimpleHolder<MarketCategory>> categories) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MarketCategoriesMessage> TYPE = new CustomPacketPayload.Type(FarmingForBlockheads.id("market_categories"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MarketCategoriesMessage> STREAM_CODEC = StreamCodec.of(MarketCategoriesMessage::encode, MarketCategoriesMessage::decode);

    public static MarketCategoriesMessage decode(RegistryFriendlyByteBuf buf) {
        int count = buf.readInt();
        ArrayList<SimpleHolder<MarketCategory>> categories = new ArrayList<SimpleHolder<MarketCategory>>();
        for (int i = 0; i < count; ++i) {
            ResourceLocation id = buf.readResourceLocation();
            ItemStack iconStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            int sortIndex = buf.readInt();
            Component tooltip = (Component)ComponentSerialization.TRUSTED_STREAM_CODEC.decode((Object)buf);
            MarketCategoryImpl category = new MarketCategoryImpl(iconStack, sortIndex, tooltip);
            categories.add(SimpleHolder.of(id, category));
        }
        return new MarketCategoriesMessage(categories);
    }

    public static void encode(RegistryFriendlyByteBuf buf, MarketCategoriesMessage message) {
        buf.writeInt(message.categories.size());
        message.categories.forEach(holder -> {
            buf.writeResourceLocation(holder.id());
            MarketCategory category = (MarketCategory)holder.value();
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)category.iconStack());
            buf.writeInt(category.sortIndex());
            ComponentSerialization.TRUSTED_STREAM_CODEC.encode((Object)buf, (Object)category.tooltip());
        });
    }

    public static void handle(Player player, MarketCategoriesMessage message) {
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof MarketMenu) {
            MarketMenu marketMenu = (MarketMenu)abstractContainerMenu;
            marketMenu.setCategories(message.categories);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

