/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.world.level.block.entity;

import fuzs.puzzleslib.api.block.v1.entity.TickingBlockEntity;
import fuzs.tradingpost.init.ModRegistry;
import fuzs.tradingpost.world.level.block.entity.TradingPostAnimationController;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class TradingPostBlockEntity
extends BlockEntity
implements Nameable,
TickingBlockEntity {
    public static final Component CONTAINER_COMPONENT = Component.translatable((String)"container.trading_post");
    public static final String TAG_CUSTOM_NAME = "CustomName";
    private final TradingPostAnimationController animationController;
    @Nullable
    private Component name;

    public TradingPostBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModRegistry.TRADING_POST_BLOCK_ENTITY_TYPE.value(), blockPos, blockState);
        this.animationController = new TradingPostAnimationController(blockPos);
    }

    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.name = TradingPostBlockEntity.parseCustomNameSafe((ValueInput)valueInput, (String)TAG_CUSTOM_NAME);
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.storeNullable(TAG_CUSTOM_NAME, ComponentSerialization.CODEC, (Object)this.name);
    }

    public void clientTick() {
        this.animationController.tick(this.getLevel());
    }

    public TradingPostAnimationController getAnimationController() {
        return this.animationController;
    }

    public Component getName() {
        return this.name != null ? this.name : CONTAINER_COMPONENT;
    }

    public void setCustomName(@Nullable Component component) {
        this.name = component;
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    protected void applyImplicitComponents(DataComponentGetter dataComponentGetter) {
        super.applyImplicitComponents(dataComponentGetter);
        this.name = (Component)dataComponentGetter.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.name);
    }

    public void removeComponentsFromTag(ValueOutput valueOutput) {
        valueOutput.discard(TAG_CUSTOM_NAME);
    }
}

