/*
 * Decompiled with CFR 0.152.
 */
package io.github.jamalam360.jamlib.client.gui;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WidgetList
extends ContainerObjectSelectionList<Entry> {
    public static final int PADDING = 4;

    public WidgetList(Minecraft minecraft, int width, int height, int y) {
        super(minecraft, width, height, y, 1);
        this.centerListVertically = false;
        this.headerHeight = 4;
    }

    public void addWidgetGroup(List<AbstractWidget> widgets) {
        this.addEntry((AbstractSelectionList.Entry)new Entry(widgets));
    }

    public void updateWidgetGroup(int index, List<AbstractWidget> widgets) {
        this.children().set(index, new Entry(widgets));
    }

    public int getRowWidth() {
        return this.width;
    }

    @Nullable
    public Entry getRealEntryAtPosition(double mouseX, double mouseY) {
        int halfRowWidth = this.getRowWidth() / 2;
        int centerX = this.getX() + this.width / 2;
        int left = centerX - halfRowWidth;
        int right = centerX + halfRowWidth;
        int m = Mth.floor((double)(mouseY - (double)this.getY())) - this.headerHeight + (int)this.scrollAmount() - 4;
        if (mouseX < (double)left || mouseX > (double)right || m < 0) {
            return null;
        }
        int height = 0;
        for (int idx = 0; idx < this.getItemCount(); ++idx) {
            Entry entry = (Entry)this.getEntry(idx);
            if (m >= (height += entry.getHeight() + 4)) continue;
            return entry;
        }
        return null;
    }

    protected void renderListItems(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        for (int itemIdx = 0; itemIdx < this.getItemCount(); ++itemIdx) {
            int top = this.getRowTop(itemIdx);
            int bottom = this.getRowBottom(itemIdx);
            if (bottom < this.getY() || top > this.getBottom()) continue;
            this.renderItem(graphics, mouseX, mouseY, partialTick, itemIdx, this.getRowLeft(), top, this.getRowWidth(), ((Entry)this.getEntry(itemIdx)).getHeight());
        }
    }

    protected int contentHeight() {
        int itemsHeight = 0;
        for (int i = 0; i < this.getItemCount(); ++i) {
            itemsHeight += ((Entry)this.getEntry(i)).getHeight() + 4;
        }
        return itemsHeight + this.headerHeight;
    }

    public int getRowTop(int index) {
        int itemsHeight = 0;
        for (int i = 0; i < index; ++i) {
            itemsHeight += ((Entry)this.getEntry(i)).getHeight() + 4;
        }
        return this.getY() - (int)this.scrollAmount() + itemsHeight + this.headerHeight;
    }

    public int getRowBottom(int index) {
        return this.getRowTop(index) + ((Entry)this.getEntry(index)).getHeight();
    }

    protected double scrollRate() {
        return 10.0;
    }

    protected int scrollBarX() {
        return this.getX() + this.width - 6;
    }

    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final List<AbstractWidget> children;
        private final List<Integer> childYs;

        private Entry(List<AbstractWidget> list) {
            this.children = ImmutableList.copyOf(list);
            this.childYs = this.children.stream().map(AbstractWidget::getY).toList();
        }

        public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            for (int i = 0; i < this.children.size(); ++i) {
                AbstractWidget widget = this.children.get(i);
                int relativeY = this.childYs.get(i);
                widget.setY(top + relativeY);
                widget.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        public int getHeight() {
            int maxY = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                AbstractWidget widget = this.children.get(i);
                int relativeY = this.childYs.get(i);
                maxY = Math.max(relativeY + widget.getHeight(), maxY);
            }
            return maxY;
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }
    }
}

