/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.beautiful_potions.mixin;

import com.cerbon.beautiful_potions.platform.Services;
import com.cerbon.beautiful_potions.potion.PotionType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.item.MissingItemModel;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemModelResolver.class})
public class ItemRendererMixin {
    @Inject(method={"appendItemLayers(Lnet/minecraft/client/renderer/item/ItemStackRenderState;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemDisplayContext;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;I)V"}, at={@At(value="INVOKE", target="Ljava/util/function/Function;apply(Ljava/lang/Object;)Ljava/lang/Object;")}, cancellable=true)
    private void appendItemLayers(ItemStackRenderState renderState, ItemStack stack, ItemDisplayContext displayContext, Level level, LivingEntity entity, int seed, CallbackInfo ci) {
        if (!(stack.getItem() instanceof PotionItem)) {
            return;
        }
        PotionContents potionContents = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (potionContents.potion().isPresent()) {
            ItemModel model;
            String variant;
            String potionId;
            String basePotionId;
            Potion potion = (Potion)((Holder)potionContents.potion().get()).value();
            ResourceLocation potionRL = BuiltInRegistries.POTION.getKey((Object)potion);
            if (potionRL == null) {
                return;
            }
            PotionType potionType = PotionType.get(stack);
            String potionNamespace = potionRL.getNamespace();
            String modelPath = potionNamespace + ":" + (basePotionId = this.getBasePotionId(potionId = potionRL.getPath())) + "/" + (variant = this.getPotionVariant(potionId, potionType));
            ResourceLocation modelLocation = ResourceLocation.tryParse((String)modelPath);
            if (modelLocation != null && (model = Services.PLATFORM.getItemModel(modelLocation, Minecraft.getInstance().getModelManager())) != null && !(model instanceof MissingItemModel)) {
                ClientLevel clientLevel;
                model.update(renderState, stack, (ItemModelResolver)this, displayContext, level instanceof ClientLevel ? (clientLevel = (ClientLevel)level) : null, entity, seed);
                ci.cancel();
            }
        }
    }

    @Unique
    private String getBasePotionId(String potionId) {
        if (potionId.startsWith("long_")) {
            return potionId.substring(5);
        }
        if (potionId.startsWith("strong_")) {
            return potionId.substring(7);
        }
        return potionId;
    }

    @Unique
    private String getPotionVariant(String potionId, PotionType potionType) {
        String typeString = potionType.toString().toLowerCase();
        if (potionId.startsWith("long_")) {
            return typeString + "_long";
        }
        if (potionId.startsWith("strong_")) {
            return typeString + "_strong";
        }
        return typeString.equals("normal") ? "normal" : typeString;
    }
}

