/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.sit;

import bl4ckscor3.mod.sit.Sit;
import bl4ckscor3.mod.sit.SitUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class SitEntity
extends Entity {
    public SitEntity(EntityType<SitEntity> type, Level level) {
        super(type, level);
    }

    public SitEntity(Level level, BlockPos pos) {
        super((EntityType)Sit.SIT_ENTITY_TYPE.get(), level);
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        this.noPhysics = true;
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Player player;
        Vec3 resetPosition;
        if (passenger instanceof Player && (resetPosition = SitUtil.getPreviousPlayerPosition(player = (Player)passenger, this)) != null) {
            BlockPos belowResetPos = BlockPos.containing((double)resetPosition.x, (double)(resetPosition.y - 1.0), (double)resetPosition.z);
            this.discard();
            if (!player.level().getBlockState(belowResetPos).isFaceSturdy((BlockGetter)this.level(), belowResetPos, Direction.UP, SupportType.FULL)) {
                return new Vec3(resetPosition.x, resetPosition.y + 1.0, resetPosition.z);
            }
            return resetPosition;
        }
        this.discard();
        return super.getDismountLocationForPassenger(passenger);
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        SitUtil.removeSitEntity(this.level(), this.blockPosition());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(ValueInput tag) {
    }

    protected void addAdditionalSaveData(ValueOutput tag) {
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, serverEntity);
    }

    public boolean hurtServer(ServerLevel level, DamageSource source, float amount) {
        return false;
    }

    public boolean shouldRender(double x, double y, double z) {
        return false;
    }
}

