/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.interfaces;

import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.data.mob_spawning.MobSpawnEntry;
import net.minecraft.world.entity.MobCategory;

public interface IMobCategory {
    public int servercore$getSpawnInterval();

    public int servercore$getOriginalCapacity();

    public void servercore$modifyCapacity(double var1);

    public void servercore$modifySpawningConfig(int var1, int var2);

    public static IMobCategory of(MobCategory category) {
        return (IMobCategory)category;
    }

    public static int getSpawnInterval(MobCategory category) {
        return IMobCategory.of(category).servercore$getSpawnInterval();
    }

    public static int getOriginalCapacity(MobCategory category) {
        return IMobCategory.of(category).servercore$getOriginalCapacity();
    }

    public static void modifyCapacity(MobCategory category, double modifier) {
        IMobCategory.of(category).servercore$modifyCapacity(modifier);
    }

    public static void reload() {
        for (MobSpawnEntry entry : Config.get().mobSpawning().categories()) {
            IMobCategory.modify(entry.category(), entry.capacity(), entry.spawnInterval());
        }
    }

    private static void modify(MobCategory category, int max, int interval) {
        IMobCategory.of(category).servercore$modifySpawningConfig(max, interval);
    }
}

