/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.client.renderer.state.BabyEnderDragonRenderState;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class BabyEnderDragonSittingModel
extends AdvancedEntityModel<BabyEnderDragonRenderState> {
    private final ModelPart Body;
    private final ModelPart FrontLeftLeg;
    private final ModelPart FrontRightLeg;
    private final ModelPart BackLeftLeg;
    private final ModelPart BackRightLeg;
    private final ModelPart Tail;
    private final ModelPart Tail2;
    private final ModelPart Tail3;
    private final ModelPart Tail4;
    private final ModelPart Neck;
    private final ModelPart Head;

    public BabyEnderDragonSittingModel(ModelPart root) {
        super(root);
        this.Body = root.getChild("Body");
        ModelPart frontBody = this.Body.getChild("FrontBody");
        this.FrontLeftLeg = frontBody.getChild("FrontLeftLeg");
        this.FrontRightLeg = frontBody.getChild("FrontRightLeg");
        this.BackLeftLeg = this.Body.getChild("BackLeftLeg");
        this.BackRightLeg = this.Body.getChild("BackRightLeg");
        this.Tail = this.Body.getChild("Tail");
        this.Tail2 = this.Tail.getChild("Tail2");
        this.Tail3 = this.Tail2.getChild("Tail3");
        this.Tail4 = this.Tail3.getChild("Tail4");
        this.Neck = frontBody.getChild("Neck");
        this.Head = this.Neck.getChild("Head");
    }

    @Override
    public void animate(BabyEnderDragonRenderState entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Neck.yRot = netHeadYaw / 3.0f * ((float)Math.PI / 180);
        this.Neck.xRot = 0.174533f + headPitch / 3.0f * ((float)Math.PI / 180);
        this.Head.yRot = netHeadYaw / 2.0f * ((float)Math.PI / 180);
        this.Head.xRot = headPitch / 2.0f * ((float)Math.PI / 180);
        this.animateSwingingTail(ageInTicks, 1.0f);
        this.BackLeftLeg.xRot = 0.6981317f;
        this.BackRightLeg.xRot = 0.6981317f;
        this.FrontLeftLeg.xRot = 0.17453292f;
        this.FrontRightLeg.xRot = 0.17453292f;
    }

    private void animateSwingingTail(float ageInTicks, float speedModifier) {
        this.Tail.xRot = 1.8325957f;
        this.Tail2.xRot = 0.20943952f;
        this.Tail3.xRot = 0.1134464f;
        this.Tail4.xRot = 0.1308997f;
        this.Tail.zRot = 0.0f;
        this.Tail2.zRot = Mth.cos((float)(ageInTicks * 0.05f * speedModifier)) * 0.15f;
        this.Tail3.zRot = Mth.cos((float)(ageInTicks * 0.05f * speedModifier)) * 0.15f;
        this.Tail4.zRot = Mth.cos((float)(ageInTicks * 0.05f * speedModifier)) * 0.35f;
        this.Tail.yRot = Mth.cos((float)(ageInTicks * 0.05f * speedModifier)) * -0.15f;
        this.Tail2.yRot = 0.0f;
        this.Tail3.yRot = 0.0f;
        this.Tail4.yRot = 0.0f;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(14, 17).addBox(-3.0f, -11.625f, 0.0f, 6.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(0, 27).addBox(-1.0f, -13.375f, 5.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 27).addBox(-1.0f, -13.375f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)22.025f, (float)-5.475f, (float)-0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition FrontBody = Body.addOrReplaceChild("FrontBody", CubeListBuilder.create().texOffs(0, 27).addBox(-2.0f, -4.75f, -7.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(19, 3).addBox(-4.0f, -3.0f, -8.0f, 6.0f, 6.0f, 7.0f, new CubeDeformation(-0.001f)), PartPose.offsetAndRotation((float)1.0f, (float)-9.5321f, (float)2.3712f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition FrontRightLeg = FrontBody.addOrReplaceChild("FrontRightLeg", CubeListBuilder.create().texOffs(46, 0).mirror().addBox(-1.25f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.5f, (float)2.0f, (float)-5.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition FrontRightLegLower = FrontRightLeg.addOrReplaceChild("FrontRightLegLower", CubeListBuilder.create().texOffs(56, 0).mirror().addBox(-0.75f, 1.475f, -1.1782f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.325f, (float)1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition FrontRightFoot = FrontRightLegLower.addOrReplaceChild("FrontRightFoot", CubeListBuilder.create().texOffs(11, 16).mirror().addBox(-3.25f, 3.3f, 3.775f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)4.0f, (float)-6.9282f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition FrontLeftLeg = FrontBody.addOrReplaceChild("FrontLeftLeg", CubeListBuilder.create().texOffs(46, 0).addBox(-1.75f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)2.0f, (float)-5.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition FrontLeftLegLower = FrontLeftLeg.addOrReplaceChild("FrontLeftLegLower", CubeListBuilder.create().texOffs(56, 0).addBox(-1.25f, 1.475f, -1.1782f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.325f, (float)1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition FrontLeftFoot = FrontLeftLegLower.addOrReplaceChild("FrontLeftFoot", CubeListBuilder.create().texOffs(11, 16).addBox(0.25f, 3.3f, 3.775f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)4.0f, (float)-6.9282f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition Neck = FrontBody.addOrReplaceChild("Neck", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -1.5f, -7.0f, 2.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)).texOffs(0, 19).addBox(-0.5f, -2.5f, -3.75f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 19).addBox(-0.5f, -2.5f, -6.225f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-0.0981f, (float)-6.3068f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition Head = Neck.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.48f, -4.0f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(16, 0).addBox(1.0f, -5.23f, -3.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 0).addBox(-2.0f, -5.23f, -3.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 10).addBox(-3.0f, -0.5f, -7.0f, 6.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 1).addBox(0.75f, -0.975f, -6.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(0, 1).addBox(-1.75f, -0.975f, -6.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-6.575f));
        PartDefinition Bell = Neck.addOrReplaceChild("Bell", CubeListBuilder.create().texOffs(41, 20).addBox(-1.0f, 1.445f, -5.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.001f)).texOffs(35, 16).addBox(-1.5f, 2.875f, -5.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftWing = FrontBody.addOrReplaceChild("LeftWing", CubeListBuilder.create().texOffs(48, 22).addBox(-0.1304f, -1.3933f, -1.4429f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(47, 8).addBox(-0.5848f, 0.15f, 0.9f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-1.6f, (float)-5.5f, (float)0.0f, (float)0.0f, (float)-1.1781f));
        PartDefinition LeftWing2 = LeftWing.addOrReplaceChild("LeftWing2", CubeListBuilder.create().texOffs(44, 28).mirror().addBox(0.7886f, -1.5405f, -1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(41, 15).mirror().addBox(0.5566f, -0.5713f, 1.025f, 8.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)4.4052f, (float)-0.6469f, (float)-0.1421f, (float)0.0f, (float)0.0f, (float)2.3998f));
        PartDefinition RightWing = FrontBody.addOrReplaceChild("RightWing", CubeListBuilder.create().texOffs(48, 22).mirror().addBox(-4.8696f, -1.3933f, -1.4429f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(47, 8).mirror().addBox(-4.4152f, 0.15f, 0.9f, 5.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.5f, (float)-1.6f, (float)-5.5f, (float)0.0f, (float)0.0f, (float)1.1781f));
        PartDefinition RightWing2 = RightWing.addOrReplaceChild("RightWing2", CubeListBuilder.create().texOffs(44, 28).addBox(-8.7886f, -1.5405f, -1.0f, 8.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(41, 15).addBox(-8.5566f, -0.5713f, 1.025f, 8.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.4052f, (float)-0.6469f, (float)-0.1421f, (float)0.0f, (float)0.0f, (float)-2.3998f));
        PartDefinition BackRightLeg = Body.addOrReplaceChild("BackRightLeg", CubeListBuilder.create().texOffs(46, 0).mirror().addBox(-1.25f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.5f, (float)-9.85f, (float)4.5f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition BackRightLegLower = BackRightLeg.addOrReplaceChild("BackRightLegLower", CubeListBuilder.create().texOffs(56, 0).mirror().addBox(-0.75f, 1.475f, -1.1782f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.325f, (float)1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition BackRightFoot = BackRightLegLower.addOrReplaceChild("BackRightFoot", CubeListBuilder.create().texOffs(11, 16).mirror().addBox(-3.25f, 3.3f, 3.775f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)4.0f, (float)-6.9282f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition BackLeftLeg = Body.addOrReplaceChild("BackLeftLeg", CubeListBuilder.create().texOffs(46, 0).mirror().addBox(-1.25f, 0.0f, -1.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)-9.85f, (float)4.5f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition BackLeftLegLower = BackLeftLeg.addOrReplaceChild("BackLeftLegLower", CubeListBuilder.create().texOffs(56, 0).mirror().addBox(-0.75f, 1.475f, -1.1782f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.325f, (float)1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition BackLeftFoot = BackLeftLegLower.addOrReplaceChild("BackLeftFoot", CubeListBuilder.create().texOffs(11, 16).mirror().addBox(-3.25f, 3.3f, 3.775f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.0f, (float)4.0f, (float)-6.9282f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition Tail = Body.addOrReplaceChild("Tail", CubeListBuilder.create().texOffs(38, 0).addBox(-1.0f, 0.0f, -0.75f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, 0).addBox(-0.5f, 0.5f, 1.25f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-9.7478f, (float)8.6125f, (float)1.825f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail.addOrReplaceChild("Tail2", CubeListBuilder.create().texOffs(38, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, 0).addBox(-0.5f, 0.5f, 1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.75f, (float)0.25f, (float)0.2094f, (float)0.0f, (float)0.0f));
        PartDefinition Tail3 = Tail2.addOrReplaceChild("Tail3", CubeListBuilder.create().texOffs(38, 0).addBox(-1.0f, 0.0f, -1.0216f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, 0).addBox(-0.5f, 0.5f, 0.9784f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.75f, (float)0.0216f, (float)0.1134f, (float)0.0f, (float)0.0f));
        PartDefinition Tail4 = Tail3.addOrReplaceChild("Tail4", CubeListBuilder.create().texOffs(38, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(22, 0).addBox(-0.5f, 0.5f, 1.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.75f, (float)-0.0216f, (float)0.1309f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }
}

