/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.client.renderer.state.FlamingoRenderState;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class FlamingoModel<T extends FlamingoRenderState>
extends AdvancedEntityModel<T> {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart LeftLegTop;
    private final ModelPart LeftLegBottom;
    private final ModelPart LeftFoot;
    private final ModelPart RightLegTop;
    private final ModelPart RightLegBottom;
    private final ModelPart RightFoot;

    public FlamingoModel(ModelPart root) {
        super(root);
        this.Body = root.getChild("Body");
        ModelPart neckBottom = this.Body.getChild("NeckBottom");
        ModelPart neck2 = neckBottom.getChild("Neck2");
        ModelPart neck3 = neck2.getChild("Neck3");
        ModelPart neck4 = neck3.getChild("Neck4");
        ModelPart neck5 = neck4.getChild("Neck5");
        ModelPart neckTop = neck5.getChild("NeckTop");
        this.Head = neckTop.getChild("Head");
        ModelPart legs = this.Body.getChild("Legs");
        this.LeftLegTop = legs.getChild("LeftLegTop");
        this.LeftLegBottom = this.LeftLegTop.getChild("LeftLegBottom");
        this.LeftFoot = this.LeftLegBottom.getChild("LeftFoot");
        this.RightLegTop = legs.getChild("RightLegTop");
        this.RightLegBottom = this.RightLegTop.getChild("RightLegBottom");
        this.RightFoot = this.RightLegBottom.getChild("RightFoot");
    }

    @Override
    public void animate(T state, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.xRot = 0.2617994f + headPitch * ((float)Math.PI / 180);
        this.Head.yRot = netHeadYaw / 3.75f * ((float)Math.PI / 180);
        if (((FlamingoRenderState)state).leftLegUp) {
            this.LeftLegTop.xRot = 1.3089969f;
            this.LeftLegBottom.xRot = -2.7052603f;
            this.LeftFoot.xRot = 0.17453292f;
            this.RightLegTop.xRot = 0.1308997f;
            this.RightLegBottom.xRot = -0.17453292f;
            this.RightFoot.xRot = 0.04363323f;
        } else if (((FlamingoRenderState)state).rightLegUp) {
            this.LeftLegTop.xRot = 0.1308997f;
            this.LeftLegBottom.xRot = -0.17453292f;
            this.LeftFoot.xRot = 0.04363323f;
            this.RightLegTop.xRot = 1.3089969f;
            this.RightLegBottom.xRot = -2.7052603f;
            this.RightFoot.xRot = 0.17453292f;
        } else {
            this.LeftLegTop.xRot = 0.1308997f + Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
            this.LeftLegBottom.xRot = -0.17453292f;
            this.LeftFoot.xRot = 0.04363323f;
            this.RightLegTop.xRot = 0.1308997f + Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
            this.RightLegBottom.xRot = -0.17453292f;
            this.RightFoot.xRot = 0.04363323f;
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(36, 49).addBox(-3.0f, -15.9f, -4.0f, 6.0f, 7.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)20.9f, (float)0.0f));
        PartDefinition Back1 = Body.addOrReplaceChild("Back1", CubeListBuilder.create().texOffs(52, 25).addBox(-2.5f, -0.4808f, -0.8778f, 5.0f, 4.0f, 1.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-12.55f, (float)7.475f, (float)-0.1833f, (float)0.0f, (float)0.0f));
        PartDefinition Back2 = Body.addOrReplaceChild("Back2", CubeListBuilder.create().texOffs(48, 31).addBox(-2.5f, 1.925f, -0.375f, 5.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-15.05f, (float)3.85f));
        PartDefinition Back3 = Body.addOrReplaceChild("Back3", CubeListBuilder.create().texOffs(44, 39).addBox(-2.5f, -0.3463f, -0.5502f, 5.0f, 4.0f, 5.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-15.3f, (float)3.8f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition Legs = Body.addOrReplaceChild("Legs", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-9.9f, (float)0.0f));
        PartDefinition LeftLegTop = Legs.addOrReplaceChild("LeftLegTop", CubeListBuilder.create().texOffs(0, 56).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)1.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLegBottom = LeftLegTop.addOrReplaceChild("LeftLegBottom", CubeListBuilder.create().texOffs(5, 57).addBox(-1.0f, 0.0f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.offsetAndRotation((float)0.5f, (float)6.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFoot = LeftLegBottom.addOrReplaceChild("LeftFoot", CubeListBuilder.create().texOffs(10, 61).addBox(-1.5f, -1.0f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)6.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition RightLegTop = Legs.addOrReplaceChild("RightLegTop", CubeListBuilder.create().texOffs(0, 46).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 7.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.0f, (float)1.0f, (float)0.0f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition RightLegBottom = RightLegTop.addOrReplaceChild("RightLegBottom", CubeListBuilder.create().texOffs(5, 47).addBox(-1.0f, 0.0f, -0.5f, 1.0f, 6.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.offsetAndRotation((float)0.5f, (float)6.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition RightFoot = RightLegBottom.addOrReplaceChild("RightFoot", CubeListBuilder.create().texOffs(10, 51).addBox(-1.5f, -1.0f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)6.0f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition NeckBottom = Body.addOrReplaceChild("NeckBottom", CubeListBuilder.create().texOffs(0, 35).addBox(-2.5f, -3.0f, -1.0f, 5.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.9f, (float)-4.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition Neck2 = NeckBottom.addOrReplaceChild("Neck2", CubeListBuilder.create().texOffs(0, 27).addBox(-2.0f, -2.5f, -1.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition Neck3 = Neck2.addOrReplaceChild("Neck3", CubeListBuilder.create().texOffs(0, 21).addBox(-1.5f, -2.0f, -1.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-1.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition Neck4 = Neck3.addOrReplaceChild("Neck4", CubeListBuilder.create().texOffs(0, 15).addBox(-1.0f, -1.5f, -2.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.1109f, (float)-1.2724f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Neck5 = Neck4.addOrReplaceChild("Neck5", CubeListBuilder.create().texOffs(0, 10).addBox(-1.0f, -0.825f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5921f, (float)-2.4868f, (float)1.3963f, (float)0.0f, (float)0.0f));
        PartDefinition NeckTop = Neck5.addOrReplaceChild("NeckTop", CubeListBuilder.create().texOffs(0, 3).addBox(-1.0f, -2.5f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.95f, (float)-0.05f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition Head = NeckTop.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(21, 28).addBox(-1.5f, -3.0f, -4.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.126f, (float)0.1477f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition Beak = Head.addOrReplaceChild("Beak", CubeListBuilder.create().texOffs(23, 19).addBox(-1.0f, -0.5152f, -3.1737f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.5619f, (float)-2.4006f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Beak2 = Beak.addOrReplaceChild("Beak2", CubeListBuilder.create().texOffs(35, 21).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.1884f, (float)-3.2262f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        PartDefinition Beak3 = Beak.addOrReplaceChild("Beak3", CubeListBuilder.create().texOffs(34, 25).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)1.1255f, (float)-3.6706f, (float)0.2662f, (float)0.0f, (float)0.0f));
        PartDefinition Wings = Body.addOrReplaceChild("Wings", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)3.1f, (float)0.0f));
        PartDefinition LeftWing = Wings.addOrReplaceChild("LeftWing", CubeListBuilder.create().texOffs(48, 0).addBox(0.0f, -2.5f, 0.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-15.5f, (float)-3.0f, (float)-0.1745f, (float)0.0873f, (float)0.0f));
        PartDefinition RightWing = Wings.addOrReplaceChild("RightWing", CubeListBuilder.create().texOffs(31, 0).addBox(-1.0f, -2.5f, 0.0f, 1.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-15.5f, (float)-3.0f, (float)-0.1745f, (float)-0.0873f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

