/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.client.renderer.state.OstrichRenderState;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class OstrichModel<T extends OstrichRenderState>
extends AdvancedEntityModel<T> {
    private final ModelPart Head;
    private final ModelPart Neck;
    private final ModelPart NeckTop;
    private final ModelPart LeftLegTop;
    private final ModelPart LeftLegBottom;
    private final ModelPart LeftFoot;
    private final ModelPart RightLegTop;
    private final ModelPart RightLegBottom;
    private final ModelPart RightFoot;

    public OstrichModel(ModelPart root) {
        super(root);
        ModelPart body = root.getChild("Body");
        this.Neck = body.getChild("Neck");
        this.NeckTop = this.Neck.getChild("NeckTop");
        this.Head = this.NeckTop.getChild("Head");
        this.LeftLegTop = body.getChild("LeftLegTop");
        this.LeftLegBottom = this.LeftLegTop.getChild("LeftLegBottom");
        this.LeftFoot = this.LeftLegBottom.getChild("LeftFoot");
        this.RightLegTop = body.getChild("RightLegTop");
        this.RightLegBottom = this.RightLegTop.getChild("RightLegBottom");
        this.RightFoot = this.RightLegBottom.getChild("RightFoot");
    }

    @Override
    protected void animate(T state, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
        this.Head.yRot = netHeadYaw / 3.75f * ((float)Math.PI / 180);
        this.NeckTop.xRot = this.Head.xRot / 1.75f;
        this.Neck.yRot = this.Head.yRot / 1.75f;
        if (((OstrichRenderState)state).isLayingEgg) {
            this.LeftLegTop.xRot = 1.1780972f;
            this.LeftLegBottom.xRot = -2.5743606f;
            this.LeftFoot.xRot = 0.61086524f;
            this.RightLegTop.xRot = 1.1780972f;
            this.RightLegBottom.xRot = -2.5743606f;
            this.RightFoot.xRot = 0.61086524f;
        } else if (((OstrichRenderState)state).isBuildingNest) {
            this.LeftLegTop.xRot = 0.3926991f;
            this.LeftLegBottom.xRot = -0.5235988f;
            this.LeftFoot.xRot = 0.17453292f;
            this.RightLegTop.xRot = 0.3926991f + Mth.cos((float)(ageInTicks * 0.45f));
            this.RightLegBottom.xRot = -0.5235988f;
            this.RightFoot.xRot = 0.17453292f;
        } else {
            this.LeftLegTop.xRot = 0.3926991f + Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
            this.LeftLegBottom.xRot = -0.5235988f;
            this.LeftFoot.xRot = 0.17453292f;
            this.RightLegTop.xRot = 0.3926991f + Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
            this.RightLegBottom.xRot = -0.5235988f;
            this.RightFoot.xRot = 0.17453292f;
        }
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 44).addBox(-4.5f, -5.0f, -4.0f, 9.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)).texOffs(42, 53).addBox(-4.0f, -5.0f, -7.0f, 8.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)8.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition Neck = Body.addOrReplaceChild("Neck", CubeListBuilder.create().texOffs(29, 0).addBox(-1.5f, -5.0f, -0.5f, 3.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)-7.5f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition NeckTop = Neck.addOrReplaceChild("NeckTop", CubeListBuilder.create().texOffs(29, 11).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)1.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition Head = NeckTop.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(29, 22).addBox(-1.5f, -3.0f, -2.75f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)0.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition Mouth = Head.addOrReplaceChild("Mouth", CubeListBuilder.create().texOffs(29, 30).addBox(-1.0f, -1.3f, -1.25f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        PartDefinition MouthTop = Mouth.addOrReplaceChild("MouthTop", CubeListBuilder.create().texOffs(29, 30).addBox(-1.0f, -0.75f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.8f, (float)-0.25f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition LeftWing = Body.addOrReplaceChild("LeftWing", CubeListBuilder.create().texOffs(44, 22).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        PartDefinition RightWing = Body.addOrReplaceChild("RightWing", CubeListBuilder.create().texOffs(44, 37).addBox(-0.5f, -2.0f, 0.0f, 1.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.5f, (float)-2.0f, (float)-3.0f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition LeftLegTop = Body.addOrReplaceChild("LeftLegTop", CubeListBuilder.create().texOffs(0, 21).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)2.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition LeftLegBottom = LeftLegTop.addOrReplaceChild("LeftLegBottom", CubeListBuilder.create().texOffs(9, 21).addBox(-1.0f, -0.6f, -1.15f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFoot = LeftLegBottom.addOrReplaceChild("LeftFoot", CubeListBuilder.create().texOffs(18, 27).addBox(-1.0f, -0.5f, -2.1f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition RightLegTop = Body.addOrReplaceChild("RightLegTop", CubeListBuilder.create().texOffs(0, 32).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)2.0f, (float)0.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition RightLegBottom = RightLegTop.addOrReplaceChild("RightLegBottom", CubeListBuilder.create().texOffs(9, 32).addBox(-1.0f, -0.6f, -1.15f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition RightFoot = RightLegBottom.addOrReplaceChild("RightFoot", CubeListBuilder.create().texOffs(18, 38).addBox(-1.0f, -0.5f, -2.1f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition Back = Body.addOrReplaceChild("Back", CubeListBuilder.create().texOffs(46, 10).addBox(-4.0f, -1.0f, -0.5f, 8.0f, 8.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)7.5f));
        PartDefinition add1 = Back.addOrReplaceChild("add1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -5.0f, -0.5f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition add1Left = add1.addOrReplaceChild("add1Left", CubeListBuilder.create().texOffs(9, 0).addBox(-1.0f, -5.0f, -2.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition add1Right = add1.addOrReplaceChild("add1Right", CubeListBuilder.create().texOffs(16, 0).addBox(-1.0f, -5.0f, -2.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition add2 = Back.addOrReplaceChild("add2", CubeListBuilder.create().texOffs(0, 7).addBox(-1.5f, -5.0f, -0.5f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)0.0f, (float)-1.1781f, (float)0.0f, (float)0.0f));
        PartDefinition add2Left = add2.addOrReplaceChild("add2Left", CubeListBuilder.create().texOffs(9, 7).addBox(-1.0f, -5.0f, -2.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.6545f));
        PartDefinition add2Right = add2.addOrReplaceChild("add2Right", CubeListBuilder.create().texOffs(9, 14).addBox(-1.0f, -5.0f, -2.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.7418f));
        PartDefinition add3 = Back.addOrReplaceChild("add3", CubeListBuilder.create().texOffs(0, 14).addBox(-1.5f, -5.0f, -0.5f, 3.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)-1.6581f, (float)0.0f, (float)0.0f));
        PartDefinition add3Left = add3.addOrReplaceChild("add3Left", CubeListBuilder.create().texOffs(16, 7).addBox(-1.0f, -5.0f, -2.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.6981f));
        PartDefinition add3Right = add3.addOrReplaceChild("add3Right", CubeListBuilder.create().texOffs(16, 14).addBox(-1.0f, -5.0f, -2.5f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.6981f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }
}

