/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tristankechlo.livingthings.LivingThings;
import com.tristankechlo.livingthings.client.ModelLayer;
import com.tristankechlo.livingthings.client.model.entity.CrabModel;
import com.tristankechlo.livingthings.client.renderer.AgeableMobRenderer;
import com.tristankechlo.livingthings.client.renderer.state.CrabRenderState;
import com.tristankechlo.livingthings.entity.CrabEntity;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class CrabRenderer
extends AgeableMobRenderer<CrabEntity, CrabRenderState, CrabModel<CrabRenderState>> {
    protected static final ResourceLocation TEXTURE_WHITE = LivingThings.getEntityTexture("crab/crab_white.png");
    protected static final ResourceLocation TEXTURE_RED = LivingThings.getEntityTexture("crab/crab_red.png");
    protected static final ResourceLocation TEXTURE_BLUE = LivingThings.getEntityTexture("crab/crab_blue.png");
    public static final MeshTransformer BABY_TRANSFORMER = MeshTransformer.scaling((float)0.6f);

    public CrabRenderer(EntityRendererProvider.Context context) {
        super(context, CrabModel::new, ModelLayer.CRAB, ModelLayer.CRAB_BABY, 0.4f);
    }

    public CrabRenderState createRenderState() {
        return new CrabRenderState();
    }

    public void extractRenderState(CrabEntity crab, CrabRenderState state, float $$2) {
        super.extractRenderState((LivingEntity)crab, (LivingEntityRenderState)state, $$2);
        state.fromEntity(crab);
    }

    public ResourceLocation getTextureLocation(CrabRenderState entity) {
        byte variant = entity.variant;
        if (variant == 2) {
            return TEXTURE_BLUE;
        }
        if (variant == 1) {
            return TEXTURE_WHITE;
        }
        return TEXTURE_RED;
    }

    protected void scale(CrabRenderState state, PoseStack poseStack) {
        if (!state.isBaby) {
            float scale = 1.0f + (float)state.scale * 0.1f;
            poseStack.scale(scale, scale, scale);
        }
        poseStack.translate(0.0, 0.01, 0.0);
        super.scale((LivingEntityRenderState)state, poseStack);
    }
}

