/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.renderer;

import com.tristankechlo.livingthings.LivingThings;
import com.tristankechlo.livingthings.client.ModelLayer;
import com.tristankechlo.livingthings.client.model.entity.GiraffeModel;
import com.tristankechlo.livingthings.client.renderer.AgeableMobRenderer;
import com.tristankechlo.livingthings.client.renderer.state.GiraffeRenderState;
import com.tristankechlo.livingthings.entity.GiraffeEntity;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class GiraffeRenderer
extends AgeableMobRenderer<GiraffeEntity, GiraffeRenderState, GiraffeModel<GiraffeRenderState>> {
    protected static final ResourceLocation TEXTURE_1 = LivingThings.getEntityTexture("giraffe/giraffe_1.png");
    protected static final ResourceLocation TEXTURE_2 = LivingThings.getEntityTexture("giraffe/giraffe_2.png");
    protected static final ResourceLocation TEXTURE_WHITE = LivingThings.getEntityTexture("giraffe/giraffe_white.png");
    public static final MeshTransformer BABY_TRANSFORMER = MeshTransformer.scaling((float)0.6f);

    public GiraffeRenderer(EntityRendererProvider.Context context) {
        super(context, GiraffeModel::new, ModelLayer.GIRAFFE, ModelLayer.GIRAFFE_BABY, 0.8f);
    }

    public GiraffeRenderState createRenderState() {
        return new GiraffeRenderState();
    }

    public void extractRenderState(GiraffeEntity entity, GiraffeRenderState state, float $$2) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, $$2);
        state.fromEntity(entity);
    }

    public ResourceLocation getTextureLocation(GiraffeRenderState state) {
        byte variant = state.variant;
        if (variant == 2) {
            return TEXTURE_WHITE;
        }
        if (variant == 1) {
            return TEXTURE_2;
        }
        return TEXTURE_1;
    }
}

