/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;

public final class FlamingoConfig
extends EntityConfig {
    private static final FlamingoConfig INSTANCE = new FlamingoConfig();
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 10.0, 1.0, 1024.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 0.25, 0.0, 1024.0);
    public final NumberValue.DoubleValue temptRange = new NumberValue.DoubleValue("temptRange", 10.0, 0.0, 2048.0);
    public final NumberValue.IntegerValue maxSpawnedInChunk = new NumberValue.IntegerValue("maxSpawnedInChunk", 6, 1, 15);
    public final ListValue<SpawnData> spawnBiomes = new ListValue<SpawnData>("spawnBiomes", FlamingoConfig.createDefaultSpawns(), SpawnData::serialize, SpawnData::deserialize);

    private FlamingoConfig() {
        super("flamingo");
        this.registerConfigValues(this.health, this.movementSpeed, this.temptRange, this.maxSpawnedInChunk, this.spawnBiomes);
    }

    public static FlamingoConfig get() {
        return INSTANCE;
    }

    public static double health() {
        return (Double)FlamingoConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)FlamingoConfig.INSTANCE.movementSpeed.get();
    }

    public static double temptRange() {
        return (Double)FlamingoConfig.INSTANCE.temptRange.get();
    }

    public static int maxSpawnedInChunk() {
        return (Integer)FlamingoConfig.INSTANCE.maxSpawnedInChunk.get();
    }

    private static List<SpawnData> createDefaultSpawns() {
        return List.of(new SpawnData(26, 3, 6, new ResourceKey[]{Biomes.RIVER, Biomes.SWAMP}));
    }
}

