/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.entity;

import com.tristankechlo.livingthings.config.util.EntityConfig;
import com.tristankechlo.livingthings.config.util.SpawnData;
import com.tristankechlo.livingthings.config.values.BooleanValue;
import com.tristankechlo.livingthings.config.values.ListValue;
import com.tristankechlo.livingthings.config.values.NumberValue;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;

public final class LionConfig
extends EntityConfig {
    private static final LionConfig INSTANCE = new LionConfig();
    public final BooleanValue canAttack = new BooleanValue("canAttack", true);
    public final NumberValue.DoubleValue health = new NumberValue.DoubleValue("health", 20.0, 1.0, 1024.0);
    public final NumberValue.DoubleValue movementSpeed = new NumberValue.DoubleValue("movementSpeed", 0.33, 0.0, 1024.0);
    public final NumberValue.DoubleValue attackDamage = new NumberValue.DoubleValue("attackDamage", 5.0, 0.0, 2048.0);
    public final NumberValue.DoubleValue temptRange = new NumberValue.DoubleValue("temptRange", 10.0, 0.0, 2048.0);
    public final NumberValue.IntegerValue maxSpawnedInChunk = new NumberValue.IntegerValue("maxSpawnedInChunk", 4, 1, 15);
    public final BooleanValue allowAllMeatAsFood = new BooleanValue("allowAllMeatAsFood", true);
    public final ListValue<SpawnData> spawnBiomes = new ListValue<SpawnData>("spawnBiomes", LionConfig.createDefaultSpawns(), SpawnData::serialize, SpawnData::deserialize);
    public final NumberValue.IntegerValue maleWeight = new NumberValue.IntegerValue("maleWeight", 50, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue femaleWeight = new NumberValue.IntegerValue("femaleWeight", 50, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue color1Weight = new NumberValue.IntegerValue("color1Weight", 99, 0, Integer.MAX_VALUE);
    public final NumberValue.IntegerValue colorWhiteWeight = new NumberValue.IntegerValue("colorWhiteWeight", 1, 0, Integer.MAX_VALUE);

    private LionConfig() {
        super("lion");
        this.registerConfigValues(this.canAttack, this.health, this.movementSpeed, this.attackDamage, this.temptRange, this.maxSpawnedInChunk, this.allowAllMeatAsFood, this.spawnBiomes);
        this.registerForCategory("genderWeights", this.maleWeight, this.femaleWeight);
        this.registerForCategory("colorWeights", this.color1Weight, this.colorWhiteWeight);
    }

    public static LionConfig get() {
        return INSTANCE;
    }

    public static boolean canAttack() {
        return LionConfig.INSTANCE.canAttack.get();
    }

    public static double health() {
        return (Double)LionConfig.INSTANCE.health.get();
    }

    public static double movementSpeed() {
        return (Double)LionConfig.INSTANCE.movementSpeed.get();
    }

    public static double attackDamage() {
        return (Double)LionConfig.INSTANCE.attackDamage.get();
    }

    public static double temptRange() {
        return (Double)LionConfig.INSTANCE.temptRange.get();
    }

    public static int maxSpawnedInChunk() {
        return (Integer)LionConfig.INSTANCE.maxSpawnedInChunk.get();
    }

    public static boolean allowAllMeatAsFood() {
        return LionConfig.INSTANCE.allowAllMeatAsFood.get();
    }

    private static List<SpawnData> createDefaultSpawns() {
        return List.of(new SpawnData(12, 2, 4, new ResourceKey[]{Biomes.SAVANNA, Biomes.SAVANNA_PLATEAU, Biomes.WINDSWEPT_SAVANNA}));
    }
}

