/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.tom.storagemod.block.BasicInventoryHopperBlock;
import com.tom.storagemod.block.CraftingTerminalBlock;
import com.tom.storagemod.block.FilingCabinetBlock;
import com.tom.storagemod.block.FramedInventoryCableBlock;
import com.tom.storagemod.block.FramedInventoryCableConnectorBlock;
import com.tom.storagemod.block.InventoryCableBlock;
import com.tom.storagemod.block.InventoryCableConnectorBlock;
import com.tom.storagemod.block.InventoryConnectorBlock;
import com.tom.storagemod.block.InventoryInterfaceBlock;
import com.tom.storagemod.block.InventoryProxyBlock;
import com.tom.storagemod.block.LevelEmitterBlock;
import com.tom.storagemod.block.OpenCrateBlock;
import com.tom.storagemod.block.PaintedTrimBlock;
import com.tom.storagemod.block.StorageTerminalBlock;
import com.tom.storagemod.block.TrimBlock;
import com.tom.storagemod.block.entity.BasicInventoryHopperBlockEntity;
import com.tom.storagemod.block.entity.CraftingTerminalBlockEntity;
import com.tom.storagemod.block.entity.FilingCabinetBlockEntity;
import com.tom.storagemod.block.entity.InventoryCableConnectorBlockEntity;
import com.tom.storagemod.block.entity.InventoryConnectorBlockEntity;
import com.tom.storagemod.block.entity.InventoryInterfaceBlockEntity;
import com.tom.storagemod.block.entity.InventoryProxyBlockEntity;
import com.tom.storagemod.block.entity.LevelEmitterBlockEntity;
import com.tom.storagemod.block.entity.OpenCrateBlockEntity;
import com.tom.storagemod.block.entity.PaintedBlockEntity;
import com.tom.storagemod.block.entity.StorageTerminalBlockEntity;
import com.tom.storagemod.components.ConfiguratorComponent;
import com.tom.storagemod.components.SimpleItemFilterComponent;
import com.tom.storagemod.components.TagFilterComponent;
import com.tom.storagemod.components.WorldPos;
import com.tom.storagemod.item.AdvWirelessTerminalItem;
import com.tom.storagemod.item.BlockItemTSS;
import com.tom.storagemod.item.FilterItem;
import com.tom.storagemod.item.InventoryConfiguratorItem;
import com.tom.storagemod.item.PaintKitItem;
import com.tom.storagemod.item.PaintedBlockItem;
import com.tom.storagemod.item.PolyFilterItem;
import com.tom.storagemod.item.TagFilterItem;
import com.tom.storagemod.item.WirelessTerminalItem;
import com.tom.storagemod.menu.CraftingTerminalMenu;
import com.tom.storagemod.menu.FilingCabinetMenu;
import com.tom.storagemod.menu.InventoryConfiguratorMenu;
import com.tom.storagemod.menu.InventoryLinkMenu;
import com.tom.storagemod.menu.ItemFilterMenu;
import com.tom.storagemod.menu.LevelEmitterMenu;
import com.tom.storagemod.menu.StorageTerminalMenu;
import com.tom.storagemod.menu.TagItemFilterMenu;
import com.tom.storagemod.platform.GameObject;
import com.tom.storagemod.platform.Platform;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class Content {
    public static final GameObject<InventoryConnectorBlock> connector = Content.blockWithItem("inventory_connector", InventoryConnectorBlock::new, p -> Content.wooden(p));
    public static final GameObject<StorageTerminalBlock> terminal = Content.blockWithItem("storage_terminal", StorageTerminalBlock::new, p -> Content.wooden(p).lightLevel(s -> 6));
    public static final GameObject<CraftingTerminalBlock> craftingTerminal = Content.blockWithItem("crafting_terminal", CraftingTerminalBlock::new, p -> Content.wooden(p).lightLevel(s -> 6));
    public static final GameObject<OpenCrateBlock> openCrate = Content.blockWithItem("open_crate", OpenCrateBlock::new, p -> Content.wooden(p));
    public static final GameObject<TrimBlock> inventoryTrim = Content.blockWithItem("trim", TrimBlock::new, p -> Content.wooden(p));
    public static final GameObject<PaintedTrimBlock> paintedTrim = Content.blockWithItemNoTab("painted_trim", PaintedTrimBlock::new, PaintedBlockItem::new, p -> Content.wooden(p), p -> p);
    public static final GameObject<LevelEmitterBlock> levelEmitter = Content.blockWithItem("level_emitter", LevelEmitterBlock::new, p -> Content.wooden(p).noOcclusion());
    public static final GameObject<InventoryCableBlock> invCable = Content.blockWithItem("inventory_cable", InventoryCableBlock::new, p -> Content.wooden(p));
    public static final GameObject<FramedInventoryCableBlock> invCableFramed = Content.blockWithItem("inventory_cable_framed", FramedInventoryCableBlock::new, PaintedBlockItem::new, p -> Content.wooden(p).noOcclusion(), p -> p);
    public static final GameObject<BasicInventoryHopperBlock> basicInvHopper = Content.blockWithItem("basic_inventory_hopper", BasicInventoryHopperBlock::new, p -> Content.wooden(p).noOcclusion());
    public static final GameObject<InventoryInterfaceBlock> invInterface = Content.blockWithItem("inventory_interface", InventoryInterfaceBlock::new, p -> Content.wooden(p));
    public static final GameObject<FilingCabinetBlock> filingCabinet = Content.blockWithItem("filing_cabinet", FilingCabinetBlock::new, p -> p.mapColor(MapColor.STONE).sound(SoundType.STONE).strength(3.0f));
    public static final GameObject<InventoryCableConnectorBlock> invCableConnector = Content.blockWithItem("inventory_cable_connector", InventoryCableConnectorBlock::new, p -> Content.wooden(p).noOcclusion());
    public static final GameObject<FramedInventoryCableConnectorBlock> invCableConnectorFramed = Content.blockWithItem("inventory_cable_connector_framed", FramedInventoryCableConnectorBlock::new, p -> Content.wooden(p).noOcclusion());
    public static final GameObject<InventoryProxyBlock> invProxy = Content.blockWithItem("inventory_proxy", InventoryProxyBlock::new, p -> Content.wooden(p));
    public static final GameObject<PaintKitItem> paintingKit = Content.item("paint_kit", PaintKitItem::new, p -> p.durability(100));
    public static final GameObject<WirelessTerminalItem> wirelessTerminal = Content.item("wireless_terminal", WirelessTerminalItem::new, p -> p.stacksTo(1));
    public static final GameObject<AdvWirelessTerminalItem> advWirelessTerminal = Content.item("adv_wireless_terminal", AdvWirelessTerminalItem::new, p -> p.stacksTo(1));
    public static final GameObject<FilterItem> itemFilter = Content.item("item_filter", FilterItem::new, p -> p.stacksTo(1));
    public static final GameObject<PolyFilterItem> polyItemFilter = Content.item("polymorphic_item_filter", PolyFilterItem::new, p -> p.stacksTo(1));
    public static final GameObject<TagFilterItem> tagItemFilter = Content.item("tag_item_filter", TagFilterItem::new, p -> p.stacksTo(1));
    public static final GameObject<InventoryConfiguratorItem> invConfig = Content.item("inventory_configurator", InventoryConfiguratorItem::new, p -> p.stacksTo(1).component(configuratorComponent.get(), (Object)ConfiguratorComponent.empty()).component(DataComponents.TOOL, (Object)new Tool(Collections.emptyList(), 0.0f, 0, false)));
    public static final GameObject.GameObjectBlockEntity<InventoryConnectorBlockEntity> connectorBE = Content.blockEntity("inventory_connector", InventoryConnectorBlockEntity::new, connector);
    public static final GameObject.GameObjectBlockEntity<OpenCrateBlockEntity> openCrateBE = Content.blockEntity("open_crate", OpenCrateBlockEntity::new, openCrate);
    public static final GameObject.GameObjectBlockEntity<PaintedBlockEntity> paintedBE = Content.blockEntity("painted", PaintedBlockEntity::new, paintedTrim, invCableFramed);
    public static final GameObject.GameObjectBlockEntity<StorageTerminalBlockEntity> terminalBE = Content.blockEntity("storage_terminal", StorageTerminalBlockEntity::new, terminal);
    public static final GameObject.GameObjectBlockEntity<CraftingTerminalBlockEntity> craftingTerminalBE = Content.blockEntity("crafting_terminal", CraftingTerminalBlockEntity::new, craftingTerminal);
    public static final GameObject.GameObjectBlockEntity<LevelEmitterBlockEntity> levelEmitterBE = Content.blockEntity("level_emitter", LevelEmitterBlockEntity::new, levelEmitter);
    public static final GameObject.GameObjectBlockEntity<BasicInventoryHopperBlockEntity> basicInvHopperBE = Content.blockEntity("basic_inventory_hopper", BasicInventoryHopperBlockEntity::new, basicInvHopper);
    public static final GameObject.GameObjectBlockEntity<InventoryInterfaceBlockEntity> invInterfaceBE = Content.blockEntity("inventory_interface", InventoryInterfaceBlockEntity::new, invInterface);
    public static final GameObject.GameObjectBlockEntity<FilingCabinetBlockEntity> filingCabinetBE = Content.blockEntity("filing_cabinet", FilingCabinetBlockEntity::new, filingCabinet);
    public static final GameObject.GameObjectBlockEntity<InventoryCableConnectorBlockEntity> cableConnectorBE = Content.blockEntity("inv_cable_connector", InventoryCableConnectorBlockEntity::new, invCableConnector, invCableConnectorFramed);
    public static final GameObject.GameObjectBlockEntity<InventoryProxyBlockEntity> invProxyBE = Content.blockEntity("inv_proxy", InventoryProxyBlockEntity::new, invProxy);
    public static final GameObject<MenuType<StorageTerminalMenu>> storageTerminalMenu = Content.menu("storage_terminal", StorageTerminalMenu::new);
    public static final GameObject<MenuType<CraftingTerminalMenu>> craftingTerminalMenu = Content.menu("crafting_terminal", CraftingTerminalMenu::new);
    public static final GameObject<MenuType<LevelEmitterMenu>> levelEmitterMenu = Content.menu("level_emitter", LevelEmitterMenu::new);
    public static final GameObject<MenuType<InventoryLinkMenu>> inventoryLink = Content.menu("inventory_link", InventoryLinkMenu::new);
    public static final GameObject<MenuType<ItemFilterMenu>> itemFilterMenu = Content.menu("item_filter", ItemFilterMenu::new);
    public static final GameObject<MenuType<TagItemFilterMenu>> tagItemFilterMenu = Content.menu("tag_item_filter", TagItemFilterMenu::new);
    public static final GameObject<MenuType<InventoryConfiguratorMenu>> invConfigMenu = Content.menu("inventory_configurator", InventoryConfiguratorMenu::new);
    public static final GameObject<MenuType<FilingCabinetMenu>> filingCabinetMenu = Content.menu("filing_cabinet", FilingCabinetMenu::new);
    public static final GameObject<DataComponentType<BlockState>> paintComponent = Platform.DATA_COMPONENT_TYPES.register("paint_state", () -> DataComponentType.builder().persistent(BlockState.CODEC).build());
    public static final GameObject<DataComponentType<WorldPos>> boundPosComponent = Platform.DATA_COMPONENT_TYPES.register("bound_pos", () -> DataComponentType.builder().persistent(WorldPos.CODEC).build());
    public static final GameObject<DataComponentType<SimpleItemFilterComponent>> simpleItemFilterComponent = Platform.DATA_COMPONENT_TYPES.register("simple_item_filter", () -> DataComponentType.builder().persistent(SimpleItemFilterComponent.CODEC).build());
    public static final GameObject<DataComponentType<TagFilterComponent>> tagFilterComponent = Platform.DATA_COMPONENT_TYPES.register("tag_filter", () -> DataComponentType.builder().persistent(TagFilterComponent.CODEC).build());
    public static final GameObject<DataComponentType<ConfiguratorComponent>> configuratorComponent = Platform.DATA_COMPONENT_TYPES.register("configurator", () -> DataComponentType.builder().persistent(ConfiguratorComponent.CODEC).build());

    private static BlockBehaviour.Properties wooden(BlockBehaviour.Properties p) {
        return p.mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(3.0f);
    }

    private static <B extends Block> GameObject<B> blockWithItem(String name, Function<BlockBehaviour.Properties, B> create, UnaryOperator<BlockBehaviour.Properties> defaultProps) {
        return Content.blockWithItem(name, create, BlockItemTSS::new, defaultProps, UnaryOperator.identity());
    }

    private static <B extends Block, I extends Item> GameObject<B> blockWithItem(String name, Function<BlockBehaviour.Properties, B> create, BiFunction<Block, Item.Properties, I> createItem, UnaryOperator<BlockBehaviour.Properties> defaultProps, UnaryOperator<Item.Properties> defaultItemProps) {
        GameObject<Block> re = Platform.BLOCKS.register(name, k -> (Block)create.apply((BlockBehaviour.Properties)defaultProps.apply(BlockBehaviour.Properties.of().setId(k))));
        Content.item(name, p -> (Item)createItem.apply((Block)re.get(), (Item.Properties)p), p -> (Item.Properties)defaultItemProps.apply(p.useBlockDescriptionPrefix()));
        return re;
    }

    private static <B extends Block, I extends Item> GameObject<B> blockWithItemNoTab(String name, Function<BlockBehaviour.Properties, B> create, BiFunction<Block, Item.Properties, I> createItem, UnaryOperator<BlockBehaviour.Properties> defaultProps, UnaryOperator<Item.Properties> defaultItemProps) {
        GameObject<Block> re = Platform.BLOCKS.register(name, k -> (Block)create.apply((BlockBehaviour.Properties)defaultProps.apply(BlockBehaviour.Properties.of().setId(k))));
        Content.itemNoTab(name, p -> (Item)createItem.apply((Block)re.get(), (Item.Properties)p), p -> (Item.Properties)defaultItemProps.apply(p.useBlockDescriptionPrefix()));
        return re;
    }

    private static <I extends Item> GameObject<I> item(String name, Function<Item.Properties, I> fact, UnaryOperator<Item.Properties> defaultProps) {
        return Content.itemNoTab(name, p -> Platform.addItemToTab((Item)fact.apply((Item.Properties)p)), defaultProps);
    }

    private static <I extends Item> GameObject<I> itemNoTab(String name, Function<Item.Properties, I> fact, UnaryOperator<Item.Properties> defaultProps) {
        return Platform.ITEMS.register(name, k -> (Item)fact.apply((Item.Properties)defaultProps.apply(new Item.Properties().setId(k))));
    }

    @SafeVarargs
    private static <BE extends BlockEntity> GameObject.GameObjectBlockEntity<BE> blockEntity(String name, GameObject.GameRegistryBE.BEFactory<? extends BE> create, GameObject<? extends Block> ... blocks) {
        return Platform.BLOCK_ENTITY.registerBE(name, create, blocks);
    }

    private static <M extends AbstractContainerMenu> GameObject<MenuType<M>> menu(String name, MenuType.MenuSupplier<M> create) {
        return Platform.MENU_TYPE.register(name, () -> new MenuType(create, FeatureFlags.VANILLA_SET));
    }

    public static void init() {
    }
}

