/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.mojang.serialization.MapCodec;
import com.tom.storagemod.block.BlockWithTooltip;
import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.block.IInventoryNode;
import com.tom.storagemod.block.NeoForgeBlock;
import com.tom.storagemod.block.entity.InventoryInterfaceBlockEntity;
import com.tom.storagemod.client.ClientUtil;
import com.tom.storagemod.inventory.InventoryCableNetwork;
import com.tom.storagemod.util.TickerUtil;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.redstone.Orientation;
import org.jetbrains.annotations.Nullable;

public class InventoryInterfaceBlock
extends BaseEntityBlock
implements IInventoryCable,
IInventoryNode,
NeoForgeBlock,
BlockWithTooltip {
    public static final MapCodec<InventoryInterfaceBlock> CODEC = InventoryInterfaceBlock.simpleCodec(InventoryInterfaceBlock::new);

    public InventoryInterfaceBlock(BlockBehaviour.Properties pr) {
        super(pr);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new InventoryInterfaceBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return TickerUtil.createTicker(world, false, true);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, Consumer<Component> tooltip, TooltipFlag tooltipFlag) {
        ClientUtil.tooltip("inventory_interface", tooltip, new Object[0]);
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void destroy(LevelAccessor p_49860_, BlockPos p_49861_, BlockState p_49862_) {
        if (p_49860_ instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)p_49860_;
            InventoryCableNetwork.getNetwork((Level)l).markNodeInvalid(p_49861_);
        }
    }

    protected void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, @Nullable Orientation orientation, boolean bl) {
        block4: {
            super.neighborChanged(blockState, level, blockPos, block, orientation, bl);
            if (level.isClientSide) break block4;
            InventoryCableNetwork n = InventoryCableNetwork.getNetwork(level);
            n.markNodeInvalid(blockPos);
            if (orientation != null) {
                for (Direction d : orientation.getDirections()) {
                    n.markNodeInvalid(blockPos.relative(d));
                }
            } else {
                for (Direction d : Direction.values()) {
                    n.markNodeInvalid(blockPos.relative(d));
                }
            }
        }
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            InventoryCableNetwork n = InventoryCableNetwork.getNetwork((Level)l);
            n.markNodeInvalid(pos);
            n.markNodeInvalid(neighbor);
        }
    }
}

