/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block.entity;

import com.tom.storagemod.Content;
import com.tom.storagemod.platform.PlatformBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class AbstractPainedBlockEntity
extends PlatformBlockEntity {
    protected BlockState blockState;

    public AbstractPainedBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    public boolean setPaintedBlockState(BlockState blockState) {
        boolean changed;
        BlockState old = this.getPaintedBlockState();
        this.blockState = blockState;
        boolean bl = changed = !this.getPaintedBlockState().equals((Object)old);
        if (changed) {
            this.markDirtyClient();
        }
        return changed;
    }

    public void loadAdditional(ValueInput compound) {
        super.loadAdditional(compound);
        this.blockState = compound.read("block", BlockState.CODEC).orElse(null);
        this.markDirtyClient();
    }

    public void saveAdditional(ValueOutput compound) {
        super.saveAdditional(compound);
        compound.storeNullable("block", BlockState.CODEC, (Object)this.blockState);
    }

    protected abstract void markDirtyClient();

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithFullMetadata(provider);
    }

    public BlockState getPaintedBlockState() {
        return this.blockState == null ? Blocks.AIR.defaultBlockState() : this.blockState;
    }

    protected void applyImplicitComponents(DataComponentGetter data) {
        super.applyImplicitComponents(data);
        this.blockState = (BlockState)data.get(Content.paintComponent.get());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        if (this.blockState != null) {
            builder.set(Content.paintComponent.get(), (Object)this.blockState);
        }
    }

    public void removeComponentsFromTag(ValueOutput compoundTag) {
        super.removeComponentsFromTag(compoundTag);
        compoundTag.discard("block");
    }
}

