/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block.entity;

import com.tom.storagemod.Content;
import com.tom.storagemod.menu.FilingCabinetMenu;
import com.tom.storagemod.util.FilingCabinetContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class FilingCabinetBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    private FilingCabinetContainer inv = new FilingCabinetContainer(512, () -> ((FilingCabinetBlockEntity)this).setChanged(), this::canInteractWith);
    private Component name;

    public FilingCabinetBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)Content.filingCabinetBE.get(), p_155229_, p_155230_);
    }

    protected void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        this.inv.storeTag(tag, "inventory");
        tag.storeNullable("CustomName", ComponentSerialization.CODEC, (Object)this.name);
    }

    protected void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.inv.fromTag(tag, "inventory");
        this.name = FilingCabinetBlockEntity.parseCustomNameSafe((ValueInput)tag, (String)"CustomName");
    }

    public AbstractContainerMenu createMenu(int p_39954_, Inventory p_39955_, Player p_39956_) {
        return new FilingCabinetMenu(p_39954_, p_39955_, this.inv);
    }

    public Component getDefaultName() {
        return Component.translatable((String)"menu.toms_storage.filing_cabinet");
    }

    public Container getInv() {
        return this.inv;
    }

    private boolean canInteractWith(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) < 64.0;
    }

    public Component getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public Component getCustomName() {
        return this.name;
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        Containers.dropContents((Level)this.level, (BlockPos)pos, (Container)this.inv);
    }
}

