/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block.entity;

import com.tom.storagemod.Config;
import com.tom.storagemod.Content;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.api.MultiblockInventoryAPI;
import com.tom.storagemod.block.IInventoryNode;
import com.tom.storagemod.block.entity.IInventoryConnector;
import com.tom.storagemod.block.entity.InventoryInterfaceBlockEntity;
import com.tom.storagemod.inventory.BlockFilter;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.IInventoryConnectorReference;
import com.tom.storagemod.inventory.InventoryCableNetwork;
import com.tom.storagemod.inventory.MultiInventoryAccess;
import com.tom.storagemod.inventory.PlatformInventoryAccess;
import com.tom.storagemod.inventory.PlatformMultiInventoryAccess;
import com.tom.storagemod.platform.PlatformBlockEntity;
import com.tom.storagemod.util.BlockFace;
import com.tom.storagemod.util.InventoryConnectorConfigUtil;
import com.tom.storagemod.util.TickerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class InventoryConnectorBlockEntity
extends PlatformBlockEntity
implements TickerUtil.TickableServer,
IInventoryConnector,
IInventoryAccess.IInventory,
IInventoryConnectorReference {
    private MultiInventoryAccess handler = new PlatformMultiInventoryAccess();
    private Map<BlockFace, PlatformInventoryAccess.BlockInventoryAccess> invAccesses = new HashMap<BlockFace, PlatformInventoryAccess.BlockInventoryAccess>();
    private Set<IInventoryAccess> connectedInvs = new HashSet<IInventoryAccess>();
    private Set<IInventoryConnector> linkedConnectors = new HashSet<IInventoryConnector>();
    private Set<BlockFace> interfaces = new HashSet<BlockFace>();

    public InventoryConnectorBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)Content.connectorBE.get(), p_155229_, p_155230_);
    }

    @Override
    public void updateServer() {
        long time = this.level.getGameTime();
        if (time % 20L == (long)(Math.abs(this.worldPosition.hashCode()) % 20)) {
            this.detectTouchingInventories();
            this.detectCableNetwork();
            this.handler.build(this, this.linkedConnectors);
        }
    }

    private void detectCableNetwork() {
        this.linkedConnectors.clear();
        Collection<BlockPos> netBlocks = InventoryCableNetwork.getNetwork(this.level).getNetworkNodes(this.worldPosition);
        for (BlockPos p : netBlocks) {
            BlockEntity be;
            if (!this.level.isLoaded(p) || (be = this.level.getBlockEntity(p)) == this || !(be instanceof IInventoryConnector)) continue;
            IInventoryConnector te = (IInventoryConnector)be;
            this.linkedConnectors.add(te);
        }
    }

    private void detectTouchingInventories() {
        BlockFilter connFilter = BlockFilter.getFilterAt(this.level, this.worldPosition);
        UnaryOperator wrapper = connFilter != null ? i -> connFilter.wrap(this.level, (IInventoryAccess)i) : UnaryOperator.identity();
        this.connectedInvs.clear();
        HashMap<BlockPos, Direction> connected = new HashMap<BlockPos, Direction>();
        HashSet<BlockFilter> blockFilters = new HashSet<BlockFilter>();
        HashSet<BlockFace> interfaces = new HashSet<BlockFace>();
        Stack<BlockPos> toCheck = new Stack<BlockPos>();
        HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
        toCheck.add(this.worldPosition);
        checkedBlocks.add(this.worldPosition);
        int maxRange = Config.get().invConnectorScanRange;
        maxRange *= maxRange;
        boolean onlyTrims = Config.get().onlyTrims;
        Consumer<BlockPos> mbCheck = opos -> {
            BlockFilter f = BlockFilter.getFilterAt(this.level, opos);
            if (f != null) {
                blockFilters.add(f);
            }
            toCheck.add((BlockPos)opos);
            checkedBlocks.add((BlockPos)opos);
        };
        while (!toCheck.isEmpty()) {
            BlockPos cp = (BlockPos)toCheck.pop();
            for (Direction d2 : Direction.values()) {
                BlockPos p2 = cp.relative(d2);
                if (checkedBlocks.contains(p2) || !(p2.distSqr((Vec3i)this.worldPosition) < (double)maxRange)) continue;
                checkedBlocks.add(p2);
                BlockState state = this.level.getBlockState(p2);
                if (state.is(StorageTags.TRIMS)) {
                    toCheck.add(p2);
                    continue;
                }
                if (state.getBlock() instanceof IInventoryNode) {
                    interfaces.add(new BlockFace(p2, Direction.DOWN));
                    toCheck.add(p2);
                    continue;
                }
                if (!InventoryConnectorConfigUtil.canConnect(state) || onlyTrims || !PlatformInventoryAccess.BlockInventoryAccess.hasInventoryAt(this.level, p2, state, d2.getOpposite())) continue;
                BlockFilter f2 = BlockFilter.getFilterAt(this.level, p2);
                if (f2 != null) {
                    blockFilters.add(f2);
                }
                connected.put(p2, d2.getOpposite());
                toCheck.add(p2);
                MultiblockInventoryAPI.EVENT.invoker().detectMultiblocks(this.level, p2, state, mbCheck);
            }
        }
        blockFilters.forEach(f -> f.getConnectedBlocks().forEach(connected::remove));
        HashMap<BlockFace, PlatformInventoryAccess.BlockInventoryAccess> invA = new HashMap<BlockFace, PlatformInventoryAccess.BlockInventoryAccess>();
        connected.forEach((p, d) -> {
            BlockFace s = new BlockFace((BlockPos)p, (Direction)d);
            PlatformInventoryAccess.BlockInventoryAccess acc = this.invAccesses.remove(s);
            if (acc == null) {
                acc = new PlatformInventoryAccess.BlockInventoryAccess();
                acc.onLoad(this.level, (BlockPos)p, (Direction)d, this);
            }
            invA.put(s, acc);
            this.connectedInvs.add((IInventoryAccess)wrapper.apply(acc));
        });
        blockFilters.forEach(f -> {
            if (f.skip()) {
                return;
            }
            BlockFace s = new BlockFace(f.getMainPos(), f.getSide());
            PlatformInventoryAccess.BlockInventoryAccess acc = this.invAccesses.remove(s);
            if (acc == null) {
                acc = new PlatformInventoryAccess.BlockInventoryAccess();
                acc.onLoad(this.level, f.getMainPos(), f.getSide(), this);
            }
            invA.put(s, acc);
            this.connectedInvs.add((IInventoryAccess)wrapper.apply(f.wrap(this.level, acc)));
        });
        this.invAccesses.values().forEach(IInventoryAccess::markInvalid);
        this.invAccesses.clear();
        this.invAccesses = invA;
        if (!this.interfaces.equals(interfaces)) {
            InventoryCableNetwork net = InventoryCableNetwork.getNetwork(this.level);
            this.interfaces.forEach(net::markNodeInvalid);
            this.interfaces = interfaces;
            net.markNodeInvalid(this.worldPosition);
        }
        for (BlockFace blockFace : this.interfaces) {
            BlockEntity blockEntity = this.level.getBlockEntity(blockFace.pos());
            if (!(blockEntity instanceof InventoryInterfaceBlockEntity)) continue;
            InventoryInterfaceBlockEntity ii = (InventoryInterfaceBlockEntity)blockEntity;
            ii.setConnectorAccess(this);
        }
    }

    public void setRemoved() {
        super.setRemoved();
        this.invAccesses.clear();
        this.handler.clear();
    }

    public UsageInfo getUsage() {
        return new UsageInfo(this.handler.getInventoryCount(), this.handler.getSlotCount(), this.handler.getFreeSlotCount());
    }

    @Override
    public IInventoryAccess getMergedHandler() {
        return this.handler;
    }

    public Set<IInventoryAccess> getConnectedInventories() {
        return this.connectedInvs;
    }

    public Set<BlockFace> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public boolean hasConnectedInventories() {
        return !this.isRemoved();
    }

    @Override
    public IInventoryAccess getInventoryAccess() {
        return this.handler;
    }

    public List<BlockPos> getConnectedBlocks() {
        return this.invAccesses.keySet().stream().map(b -> b.pos()).toList();
    }

    @Override
    public Collection<IInventoryConnector> getConnectedConnectors() {
        return this.linkedConnectors;
    }

    @Override
    public IInventoryConnector getConnectorRef() {
        return this;
    }

    public record UsageInfo(int blocks, int all, int free) {
    }
}

