/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.emi;

import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.menu.CraftingTerminalMenu;
import com.tom.storagemod.screen.AbstractStorageTerminalScreen;
import com.tom.storagemod.util.IAutoFillTerminal;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class EmiTransferHandler
implements StandardRecipeHandler<CraftingTerminalMenu> {
    public List<Slot> getInputSources(CraftingTerminalMenu handler) {
        return Collections.emptyList();
    }

    public List<Slot> getCraftingSlots(CraftingTerminalMenu handler) {
        return Collections.emptyList();
    }

    public EmiPlayerInventory getInventory(AbstractContainerScreen<CraftingTerminalMenu> screen) {
        AbstractStorageTerminalScreen scr;
        ArrayList stacks = new ArrayList();
        ((CraftingTerminalMenu)screen.getMenu()).slots.subList(1, ((CraftingTerminalMenu)screen.getMenu()).slots.size()).stream().map(Slot::getItem).map(EmiStack::of).forEach(stacks::add);
        if (screen instanceof AbstractStorageTerminalScreen && (scr = (AbstractStorageTerminalScreen)screen).isSmartItemSearchOn()) {
            ((CraftingTerminalMenu)screen.getMenu()).getStoredItems().forEach(s -> stacks.add(EmiStack.of((ItemStack)s.getStack(), (long)s.getQuantity())));
        }
        return new EmiPlayerInventory(stacks);
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return recipe.getCategory() == VanillaEmiRecipeCategories.CRAFTING && recipe.supportsRecipeTree();
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<CraftingTerminalMenu> context) {
        return context.getInventory().canCraft(recipe);
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<CraftingTerminalMenu> context) {
        AbstractContainerScreen screen = context.getScreen();
        EmiTransferHandler.handleRecipe(recipe, (AbstractContainerScreen<CraftingTerminalMenu>)screen, false);
        Minecraft.getInstance().setScreen((Screen)screen);
        return true;
    }

    public void render(EmiRecipe recipe, EmiCraftContext<CraftingTerminalMenu> context, List<Widget> widgets, GuiGraphics matrices) {
        AbstractStorageTerminalScreen scr;
        AbstractContainerScreen abstractContainerScreen = context.getScreen();
        if (abstractContainerScreen instanceof AbstractStorageTerminalScreen && (scr = (AbstractStorageTerminalScreen)abstractContainerScreen).isSmartItemSearchOn()) {
            List<Integer> missing = EmiTransferHandler.handleRecipe(recipe, (AbstractContainerScreen<CraftingTerminalMenu>)context.getScreen(), true);
            int i = 0;
            for (Widget w : widgets) {
                if (!(w instanceof SlotWidget)) continue;
                SlotWidget sw = (SlotWidget)w;
                int j = i++;
                EmiIngredient stack = sw.getStack();
                Bounds bounds = sw.getBounds();
                if (sw.getRecipe() != null || stack.isEmpty() || !missing.contains(j)) continue;
                matrices.fill(bounds.x(), bounds.y(), bounds.x() + bounds.width(), bounds.y() + bounds.height(), 0x44FF0000);
            }
        }
    }

    private static List<Integer> handleRecipe(EmiRecipe recipe, AbstractContainerScreen<CraftingTerminalMenu> screen, boolean simulate) {
        IAutoFillTerminal term = (IAutoFillTerminal)screen.getMenu();
        ItemStack[][] stacks = (ItemStack[][])recipe.getInputs().stream().map(i -> (ItemStack[])i.getEmiStacks().stream().map(EmiStack::getItemStack).filter(s -> !s.isEmpty()).toArray(ItemStack[]::new)).toArray(x$0 -> new ItemStack[x$0][]);
        int width = recipe.getDisplayWidth();
        ArrayList<Integer> missing = new ArrayList<Integer>();
        HashSet<StoredItemStack> stored = new HashSet<StoredItemStack>(term.getStoredItems());
        int i2 = 0;
        for (ItemStack[] list : stacks) {
            if (list.length > 0) {
                boolean found = false;
                for (ItemStack stack : list) {
                    if (stack == null || Minecraft.getInstance().player.getInventory().findSlotMatchingItem(stack) == -1) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (ItemStack stack : list) {
                        StoredItemStack s = new StoredItemStack(stack);
                        if (!stored.contains(s)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    missing.add(width == 1 ? i2 * 3 : (width == 2 ? i2 % 2 + i2 / 2 * 3 : i2));
                }
            }
            ++i2;
        }
        if (!simulate) {
            // empty if block
        }
        return missing;
    }
}

