/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.item;

import com.tom.storagemod.Content;
import com.tom.storagemod.block.IPaintable;
import com.tom.storagemod.client.ClientUtil;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PaintKitItem
extends Item {
    public PaintKitItem(Item.Properties pr) {
        super(pr);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay p_399753_, Consumer<Component> tooltip, TooltipFlag tooltipFlag) {
        ClientUtil.tooltip("paint_kit", tooltip, new Object[0]);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (!context.getLevel().isClientSide) {
            BlockState st;
            if (context.isSecondaryUseActive()) {
                BlockState state = context.getLevel().getBlockState(context.getClickedPos());
                BlockEntity tile = context.getLevel().getBlockEntity(context.getClickedPos());
                if (tile == null && state.canOcclude() && Block.isShapeFullBlock((VoxelShape)state.getShape((BlockGetter)context.getLevel(), context.getClickedPos()))) {
                    ItemStack is = context.getItemInHand();
                    is.applyComponents(DataComponentPatch.builder().set(Content.paintComponent.get(), (Object)state).build());
                }
                return InteractionResult.SUCCESS;
            }
            BlockState state = context.getLevel().getBlockState(context.getClickedPos());
            ItemStack is = context.getItemInHand();
            if (state.getBlock() instanceof IPaintable && (st = (BlockState)is.get(Content.paintComponent.get())) != null) {
                if (((IPaintable)state.getBlock()).paint(context.getLevel(), context.getClickedPos(), st)) {
                    Player playerentity = context.getPlayer();
                    context.getLevel().playSound((Entity)playerentity, context.getClickedPos(), SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (playerentity != null) {
                        is.hurtAndBreak(1, (LivingEntity)context.getPlayer(), context.getHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                        if (is.isEmpty()) {
                            playerentity.setItemInHand(context.getHand(), new ItemStack((ItemLike)Items.BUCKET));
                        }
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            BlockState state = context.getLevel().getBlockState(context.getClickedPos());
            if (context.isSecondaryUseActive()) {
                return InteractionResult.SUCCESS;
            }
            if (state.getBlock() instanceof IPaintable) {
                return InteractionResult.SUCCESS;
            }
        }
        return super.useOn(context);
    }

    public Component getName(ItemStack is) {
        MutableComponent tc = super.getName(is).copy();
        BlockState st = (BlockState)is.get(Content.paintComponent.get());
        if (st != null) {
            tc.append(" (");
            tc.append((Component)st.getBlock().getName().withStyle(ChatFormatting.GREEN));
            tc.append(")");
        }
        return tc;
    }
}

