/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.jade;

import com.tom.storagemod.jade.JadePlugin;
import com.tom.storagemod.util.Priority;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.api.ui.ResizeableElement;

public enum InventoryConfigComponentProvider implements IBlockComponentProvider
{
    INSTANCE;


    public ResourceLocation getUid() {
        return JadePlugin.INVENTORY_CONFIG;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        if (accessor.getServerData().getBooleanOr("bf", false)) {
            boolean skip = accessor.getServerData().getBooleanOr("skip", false);
            ValueInput in = TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (CompoundTag)accessor.getServerData());
            ItemStack f = in.read("filter", ItemStack.CODEC).orElse(ItemStack.EMPTY);
            tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.block_filter"));
            Priority pr = Priority.VALUES[Math.abs(accessor.getServerData().getByteOr("pr", (byte)0)) % Priority.VALUES.length];
            if (skip) {
                tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.block_filter.skip"));
            } else {
                tooltip.add((Component)Component.translatable((String)("tooltip.toms_storage.priority_" + pr.name().toLowerCase(Locale.ROOT))));
                if (!f.isEmpty()) {
                    if (accessor.showDetails()) {
                        ITooltip t = JadeUI.tooltip();
                        ResizeableElement icon = JadeUI.item((ItemStack)f, (float)1.0f).size(18, 18).offset(0, -1);
                        t.add((LayoutElement)icon);
                        f.getTooltipLines(Item.TooltipContext.of((Level)accessor.getLevel()), accessor.getPlayer(), (TooltipFlag)TooltipFlag.Default.NORMAL).forEach(arg_0 -> ((ITooltip)t).add(arg_0));
                        BoxStyle b = BoxStyle.transparent().clone();
                        b.borderWidth = 1;
                        tooltip.add((LayoutElement)JadeUI.box((ITooltip)t, (BoxStyle)b));
                    } else {
                        tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.block_filter.item", (Object[])new Object[]{f.getHoverName()}));
                    }
                }
            }
        }
    }
}

