/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.menu;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tom.storagemod.Content;
import com.tom.storagemod.block.entity.InventoryCableConnectorBlockEntity;
import com.tom.storagemod.inventory.RemoteConnections;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.util.DataSlots;
import com.tom.storagemod.util.IDataReceiver;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;

public class InventoryLinkMenu
extends AbstractContainerMenu
implements IDataReceiver {
    private InventoryCableConnectorBlockEntity te;
    private Inventory pinv;
    private boolean sentList;
    public int beaconLvl;

    public InventoryLinkMenu(int id, Inventory playerInv) {
        this(id, playerInv, null);
    }

    public InventoryLinkMenu(int id, Inventory playerInv, InventoryCableConnectorBlockEntity tile) {
        super(Content.inventoryLink.get(), id);
        this.te = tile;
        this.pinv = playerInv;
        this.addDataSlot(DataSlots.create(v -> {
            this.beaconLvl = v;
        }, () -> this.te != null ? this.te.getBeaconLevel() : 0));
    }

    @Override
    public void receive(ValueInput tag) {
        if (this.pinv.player.isSpectator() || this.te == null) {
            return;
        }
        tag.read("id", UUIDUtil.CODEC).ifPresentOrElse(id -> {
            if (tag.getBooleanOr("select", false)) {
                RemoteConnections.Channel c = RemoteConnections.get(this.pinv.player.level()).getChannel((UUID)id);
                if (c != null && c.canAccess(this.pinv.player)) {
                    this.te.setChannel((UUID)id);
                }
            } else {
                tag.read("p", (Codec)Codec.BOOL).ifPresentOrElse(p -> RemoteConnections.get(this.pinv.player.level()).editChannel((UUID)id, (boolean)p, this.pinv.player.getUUID()), () -> RemoteConnections.get(this.pinv.player.level()).removeChannel((UUID)id, this.pinv.player.getUUID()));
            }
        }, () -> {
            UUID chn = RemoteConnections.get(this.pinv.player.level()).makeChannel(tag.getStringOr("d", "No Name"), tag.getBooleanOr("p", false), this.pinv.player);
            this.te.setChannel(chn);
        });
        this.sentList = false;
    }

    public boolean stillValid(Player p_38874_) {
        return this.te != null ? this.te.stillValid(p_38874_) : true;
    }

    public void broadcastChanges() {
        if (this.te == null) {
            return;
        }
        if (!this.sentList) {
            CompoundTag mainTag = new CompoundTag();
            UUID chn = this.te.getChannel();
            if (chn != null) {
                mainTag.store("selected", UUIDUtil.CODEC, (Object)chn);
            }
            ListTag list = new ListTag();
            RemoteConnections.get(this.pinv.player.level()).streamChannels(this.pinv.player).map(LinkChannel::create).forEach(c -> {
                CompoundTag t = new CompoundTag();
                c.saveToClient(t);
                list.add((Object)t);
            });
            mainTag.put("list", (Tag)list);
            NetworkHandler.sendTo((ServerPlayer)this.pinv.player, mainTag);
            this.sentList = true;
        }
        super.broadcastChanges();
    }

    public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
        return ItemStack.EMPTY;
    }

    public record LinkChannel(UUID id, String displayName, boolean publicChannel, UUID owner, String ownerName) {
        public static final MapCodec<LinkChannel> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)UUIDUtil.CODEC.optionalFieldOf("id", null).forGetter(LinkChannel::id), (App)Codec.STRING.fieldOf("d").forGetter(LinkChannel::displayName), (App)Codec.BOOL.fieldOf("p").forGetter(LinkChannel::publicChannel), (App)UUIDUtil.CODEC.optionalFieldOf("o", null).forGetter(LinkChannel::owner), (App)Codec.STRING.optionalFieldOf("on", null).forGetter(LinkChannel::ownerName)).apply((Applicative)b, LinkChannel::new));

        public LinkChannel(boolean isPublic, String name) {
            this(null, name, isPublic, null, null);
        }

        public static LinkChannel create(Map.Entry<UUID, RemoteConnections.Channel> e) {
            RemoteConnections.Channel c = e.getValue();
            return new LinkChannel(e.getKey(), c.displayName, c.publicChannel, c.owner, c.ownerName);
        }

        public void saveToClient(CompoundTag t) {
            t.store("id", UUIDUtil.CODEC, (Object)this.id);
            t.putString("d", this.displayName);
            t.putBoolean("p", this.publicChannel);
            t.store("o", UUIDUtil.CODEC, (Object)this.owner);
            t.putString("on", this.ownerName == null ? "" : this.ownerName);
        }

        public void saveToServer(CompoundTag t) {
            t.putBoolean("p", this.publicChannel);
            t.putString("d", this.displayName);
        }
    }
}

