/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.menu;

import com.tom.storagemod.block.entity.CraftingTerminalBlockEntity;
import com.tom.storagemod.inventory.StoredItemStack;
import com.tom.storagemod.platform.Platform;
import com.tom.storagemod.util.TerminalSyncManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class TerminalCraftingFiller {
    private CraftingTerminalBlockEntity te;
    private Player player;
    private Map<Holder<Item>, List<ItemStack>> allItems = new HashMap<Holder<Item>, List<ItemStack>>();
    private TerminalSyncManager sync;

    public TerminalCraftingFiller(CraftingTerminalBlockEntity te, Player player, TerminalSyncManager sync) {
        this.te = te;
        this.player = player;
        this.sync = sync;
    }

    public void placeRecipe(Recipe<?> recipe) {
        this.te.clear(this.player);
        this.sync.fillCraftingFiller(this);
        for (ItemStack i : this.player.getInventory().getNonEquipmentItems()) {
            this.accountStack(i);
        }
        List ings = recipe.placementInfo().ingredients();
        PlaceRecipeHelper.placeRecipe((int)3, (int)3, recipe, (Iterable)recipe.placementInfo().slotsToIngredientIndex(), (idx, slotId, _1, _2) -> {
            if (idx == -1) {
                return;
            }
            Ingredient ingr = (Ingredient)ings.get((int)idx);
            boolean filled = false;
            for (Holder<Item> v : Platform.getIngredientItems(ingr)) {
                List<ItemStack> lst = this.allItems.get(v);
                if (lst == null) continue;
                for (ItemStack item : lst) {
                    if (!ingr.test(item)) continue;
                    StoredItemStack pull = this.te.pullStack(new StoredItemStack(item), 1L);
                    if (pull != null) {
                        filled = true;
                        this.te.setCraftSlot(slotId, pull.getActualStack());
                        break;
                    }
                    int id = this.player.getInventory().findSlotMatchingItem(item);
                    if (id == -1) continue;
                    this.te.setCraftSlot(slotId, this.player.getInventory().removeItem(id, 1));
                    filled = true;
                    break;
                }
                if (!filled) continue;
                break;
            }
        });
    }

    public void accountStack(ItemStack st) {
        if (st.has(DataComponents.CUSTOM_NAME)) {
            return;
        }
        this.allItems.computeIfAbsent((Holder<Item>)st.getItemHolder(), __ -> new ArrayList()).add(st);
    }
}

