/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.screen;

import com.tom.storagemod.menu.FilingCabinetMenu;
import com.tom.storagemod.screen.IScreen;
import com.tom.storagemod.screen.TSContainerScreen;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import org.lwjgl.glfw.GLFW;

public class FilingCabinetScreen
extends TSContainerScreen<FilingCabinetMenu> {
    private static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocation.parse((String)"textures/gui/container/generic_54.png");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.parse((String)"container/creative_inventory/scroller");
    private static final ResourceLocation SIDE_SCROLLBAR = ResourceLocation.tryBuild((String)"toms_storage", (String)"textures/gui/side_scrollbar.png");
    private final int containerRows;
    private int lastScroll;
    protected float currentScroll;
    protected boolean isScrolling;
    protected boolean wasClicking;

    public FilingCabinetScreen(FilingCabinetMenu inv, Inventory p_97742_, Component p_97743_) {
        super(inv, p_97742_, p_97743_);
        this.containerRows = inv.getRowCount();
        this.imageHeight = 114 + this.containerRows * 18;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    public void render(GuiGraphics st, int mouseX, int mouseY, float p_281873_) {
        boolean flag = GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)0) != 0;
        int i = this.leftPos;
        int j = this.topPos;
        int k = i + 174;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + this.containerRows * 18;
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = true;
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = Mth.clamp((float)this.currentScroll, (float)0.0f, (float)1.0f);
        }
        super.render(st, mouseX, mouseY, p_281873_);
        i = k;
        j = l;
        k = j1;
        st.blitSprite(RenderPipelines.GUI_TEXTURED, SCROLLER_SPRITE, i, j + (int)((float)(k - j - 17) * this.currentScroll), 12, 15);
        this.renderTooltip(st, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics st, float p_282334_, int p_282603_, int p_282158_) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        st.blit(RenderPipelines.GUI_TEXTURED, CONTAINER_BACKGROUND, i, j, 0.0f, 0.0f, this.imageWidth, this.containerRows * 18 + 17, 256, 256);
        st.blit(RenderPipelines.GUI_TEXTURED, CONTAINER_BACKGROUND, i, j + this.containerRows * 18 + 17, 0.0f, 126.0f, this.imageWidth, 96, 256, 256);
        st.blit(RenderPipelines.GUI_TEXTURED, SIDE_SCROLLBAR, i + 170, j, 0.0f, 0.0f, 24, 115, 24, 115, 256, 256);
    }

    protected void containerTick() {
        int i = (((FilingCabinetMenu)this.menu).getContainerSize() + 9 - 1) / 9 - this.containerRows;
        int scroll = (int)((double)(this.currentScroll * (float)i) + 0.5);
        if (this.lastScroll != scroll) {
            this.scroll(scroll);
            this.lastScroll = scroll;
        }
    }

    private void scroll(int id) {
        ((FilingCabinetMenu)this.getMenu()).setRow(id);
        this.minecraft.gameMode.handleInventoryButtonClick(((FilingCabinetMenu)this.menu).containerId, id);
    }

    @Override
    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double xd, double p_mouseScrolled_5_) {
        int i = (((FilingCabinetMenu)this.menu).getContainerSize() + 9 - 1) / 9 - 5;
        this.currentScroll = (float)((double)this.currentScroll - p_mouseScrolled_5_ / (double)i);
        this.currentScroll = Mth.clamp((float)this.currentScroll, (float)0.0f, (float)1.0f);
        return true;
    }

    @Override
    public void getExclusionAreas(Consumer<IScreen.Box> consumer) {
    }
}

