/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.screen;

import com.tom.storagemod.menu.InventoryLinkMenu;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.screen.IScreen;
import com.tom.storagemod.screen.TSContainerScreen;
import com.tom.storagemod.screen.widget.IconButton;
import com.tom.storagemod.screen.widget.ListWidget;
import com.tom.storagemod.screen.widget.ToggleButton;
import com.tom.storagemod.util.IDataReceiver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.storage.ValueInput;

public class InventoryLinkScreen
extends TSContainerScreen<InventoryLinkMenu>
implements IDataReceiver {
    private static final ResourceLocation gui = ResourceLocation.tryBuild((String)"toms_storage", (String)"textures/gui/inventory_link.png");
    private static final ResourceLocation privateChannel = ResourceLocation.tryBuild((String)"toms_storage", (String)"icons/lock_on");
    private static final ResourceLocation publicChannel = ResourceLocation.tryBuild((String)"toms_storage", (String)"icons/lock_off");
    private EditBox textF;
    private Map<UUID, InventoryLinkMenu.LinkChannel> connections = new HashMap<UUID, InventoryLinkMenu.LinkChannel>();
    private IconButton createBtn;
    private IconButton deleteBtn;
    private ToggleButton publicBtn;
    private List<InventoryLinkMenu.LinkChannel> sortedList = new ArrayList<InventoryLinkMenu.LinkChannel>();
    private ListHandler channelsList;
    protected float currentScroll;
    protected boolean isScrolling;
    protected boolean wasClicking;

    public InventoryLinkScreen(InventoryLinkMenu p_97741_, Inventory p_97742_, Component p_97743_) {
        super(p_97741_, p_97742_, p_97743_);
    }

    @Override
    public void receive(ValueInput tag) {
        this.connections.clear();
        tag.listOrEmpty("list", InventoryLinkMenu.LinkChannel.CODEC.codec()).stream().forEach(l -> this.connections.put(l.id(), (InventoryLinkMenu.LinkChannel)l));
        tag.read("selected", UUIDUtil.CODEC).ifPresentOrElse(sel -> {
            InventoryLinkMenu.LinkChannel selC = this.connections.get(sel);
            if (selC != null) {
                this.channelsList.setSelected(selC);
                this.textF.setValue(selC.displayName());
            } else {
                this.channelsList.setSelected(null);
            }
        }, () -> this.channelsList.setSelected(null));
        Comparator<InventoryLinkMenu.LinkChannel> cmp = Comparator.comparing(InventoryLinkMenu.LinkChannel::publicChannel);
        cmp = cmp.thenComparing(InventoryLinkMenu.LinkChannel::displayName);
        this.sortedList = this.connections.values().stream().sorted(cmp).collect(Collectors.toList());
        this.update();
    }

    protected void renderBg(GuiGraphics matrixStack, float partialTicks, int x, int y) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        matrixStack.blit(RenderPipelines.GUI_TEXTURED, gui, i, j, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics st, int p_97809_, int p_97810_) {
        st.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, -12566464, false);
        st.drawString(this.font, I18n.get((String)"label.toms_storage.inventory_connector.beacon_level", (Object[])new Object[]{((InventoryLinkMenu)this.menu).beaconLvl}), this.titleLabelX, this.titleLabelY + 10, -12566464, false);
    }

    protected void init() {
        this.clearWidgets();
        super.init();
        this.createBtn = (IconButton)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + 121, this.topPos + 24, (Component)Component.translatable((String)""), ResourceLocation.tryBuild((String)"toms_storage", (String)"icons/add"), b -> {
            String name = this.textF.getValue().trim();
            if (!name.isEmpty()) {
                this.sendEdit(null, new InventoryLinkMenu.LinkChannel(this.publicBtn.getState(), name));
            }
        }));
        this.deleteBtn = (IconButton)this.addRenderableWidget((GuiEventListener)new IconButton(this.leftPos + 138, this.topPos + 24, (Component)Component.translatable((String)""), ResourceLocation.tryBuild((String)"toms_storage", (String)"icons/deny"), b -> this.sendEdit((InventoryLinkMenu.LinkChannel)this.channelsList.getSelected(), null)));
        this.publicBtn = (ToggleButton)this.addRenderableWidget((GuiEventListener)ToggleButton.builder(this.leftPos + 155, this.topPos + 24).iconOff(privateChannel).iconOn(publicChannel).build(s -> {
            InventoryLinkMenu.LinkChannel sel = (InventoryLinkMenu.LinkChannel)this.channelsList.getSelected();
            if (sel != null && sel.owner().equals(this.minecraft.player.getUUID())) {
                this.sendEdit(sel, new InventoryLinkMenu.LinkChannel(s, sel.displayName()));
            }
        }));
        this.publicBtn.setTooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.toms_storage.inv_link.private")), Tooltip.create((Component)Component.translatable((String)"tooltip.toms_storage.inv_link.public")));
        this.channelsList = new ListHandler(this.leftPos + 12, this.topPos + 42);
        this.channelsList.setList(() -> this.sortedList);
        this.addRenderableWidget((GuiEventListener)this.channelsList);
        Objects.requireNonNull(this.font);
        this.textF = new EditBox(this.font, this.leftPos + 13, this.topPos + 28, 105, 9, (Component)Component.translatable((String)"narrator.toms_storage.inventory_link_channel"));
        this.textF.setMaxLength(50);
        this.textF.setBordered(false);
        this.textF.setVisible(true);
        this.textF.setTextColor(-1);
        this.textF.setValue("");
        this.textF.setResponder(t -> {
            this.channelsList.setSelected(null);
            for (Map.Entry<UUID, InventoryLinkMenu.LinkChannel> e : this.connections.entrySet()) {
                if (!e.getValue().displayName().equals(t)) continue;
                this.channelsList.setSelected(e.getValue());
                break;
            }
            this.update();
        });
        this.addRenderableWidget((GuiEventListener)this.textF);
        this.update();
    }

    private void sendEdit(InventoryLinkMenu.LinkChannel id, InventoryLinkMenu.LinkChannel ch) {
        CompoundTag tag = new CompoundTag();
        if (id != null) {
            tag.store("id", UUIDUtil.CODEC, (Object)id.id());
        }
        if (ch != null) {
            ch.saveToServer(tag);
        }
        NetworkHandler.sendDataToServer(tag);
    }

    private void sendSelect(UUID id) {
        CompoundTag tag = new CompoundTag();
        tag.store("id", UUIDUtil.CODEC, (Object)id);
        tag.putBoolean("select", true);
        NetworkHandler.sendDataToServer(tag);
    }

    private void update() {
        InventoryLinkMenu.LinkChannel sel = (InventoryLinkMenu.LinkChannel)this.channelsList.getSelected();
        if (sel != null) {
            boolean owner;
            this.deleteBtn.active = true;
            this.publicBtn.setState(sel.publicChannel());
            this.publicBtn.active = owner = sel.owner().equals(this.minecraft.player.getUUID());
            this.createBtn.active = false;
        } else {
            this.deleteBtn.active = false;
            this.publicBtn.setState(false);
            this.createBtn.active = !this.textF.getValue().trim().isEmpty();
        }
    }

    public void render(GuiGraphics st, int mouseX, int mouseY, float partialTicks) {
        this.channelsList.preRender(mouseX, mouseY);
        super.render(st, mouseX, mouseY, partialTicks);
        this.renderTooltip(st, mouseX, mouseY);
        this.channelsList.tooltip(st, mouseX, mouseY);
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.onClose();
            return true;
        }
        if (p_keyPressed_1_ == 258) {
            return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        }
        return !this.textF.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) && !this.textF.canConsumeInput() ? super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : true;
    }

    public boolean charTyped(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.textF.charTyped(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.charTyped(p_charTyped_1_, p_charTyped_2_);
    }

    @Override
    public void getExclusionAreas(Consumer<IScreen.Box> consumer) {
    }

    public class ListHandler
    extends ListWidget<InventoryLinkMenu.LinkChannel> {
        public ListHandler(int x, int y) {
            super(x, y, 114, 100, 16, (Component)Component.empty());
        }

        @Override
        protected Font getFont() {
            return InventoryLinkScreen.this.font;
        }

        @Override
        protected void addButton(AbstractWidget btn) {
            InventoryLinkScreen.this.addRenderableWidget((GuiEventListener)btn);
        }

        @Override
        protected Component toComponent(InventoryLinkMenu.LinkChannel data) {
            return Component.literal((String)data.displayName());
        }

        @Override
        protected void renderTooltip(GuiGraphics graphics, InventoryLinkMenu.LinkChannel data, int mouseX, int mouseY) {
            ArrayList<MutableComponent> tt = new ArrayList<MutableComponent>();
            if (!data.ownerName().isEmpty()) {
                boolean owner = data.owner().equals(((InventoryLinkScreen)InventoryLinkScreen.this).minecraft.player.getUUID());
                tt.add(Component.translatable((String)("tooltip.toms_storage.inventory_connector.channel.owner" + (owner ? ".self" : "")), (Object[])new Object[]{data.ownerName()}));
            } else {
                tt.add(Component.translatable((String)"tooltip.toms_storage.inventory_connector.channel.owner.unknown"));
            }
            tt.add(Component.translatable((String)("tooltip.toms_storage.inv_link." + (data.publicChannel() ? "public" : "private"))));
            graphics.setComponentTooltipForNextFrame(InventoryLinkScreen.this.font, tt, mouseX, mouseY);
        }

        @Override
        protected void renderEntry(GuiGraphics st, int x, int y, int width, int height, InventoryLinkMenu.LinkChannel id, int mouseX, int mouseY, float pt) {
            st.blitSprite(RenderPipelines.GUI_TEXTURED, id.publicChannel() ? publicChannel : privateChannel, x + width - 16, y, 16, 16);
        }

        @Override
        protected void selectionChanged(InventoryLinkMenu.LinkChannel to) {
            InventoryLinkScreen.this.sendSelect(to.id());
            InventoryLinkScreen.this.update();
        }
    }
}

