/*
 * Decompiled with CFR 0.152.
 */
package com.vsngarcia.level;

import com.vsngarcia.level.ElevatorBlockEntityBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ElevatorContainer
extends AbstractContainerMenu {
    private final Direction playerFacing;
    private ElevatorBlockEntityBase elevatorTile;
    private final BlockPos pos;

    public ElevatorContainer(MenuType<ElevatorContainer> menuType, int id, BlockPos pos, Player player) {
        super(menuType, id);
        BlockEntity tile = player.level().getBlockEntity(pos);
        if (tile instanceof ElevatorBlockEntityBase) {
            this.elevatorTile = (ElevatorBlockEntityBase)tile;
        }
        this.playerFacing = player.getDirection();
        this.pos = pos;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int id) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player playerIn) {
        return ElevatorContainer.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)playerIn.level(), (BlockPos)this.elevatorTile.getBlockPos()), (Player)playerIn, (Block)this.elevatorTile.getBlockState().getBlock());
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ElevatorBlockEntityBase getTile() {
        return this.elevatorTile;
    }

    public Direction getPlayerFacing() {
        return this.playerFacing;
    }
}

