/*
 * Decompiled with CFR 0.152.
 */
package com.vsngarcia.neoforge.client;

import com.mojang.math.Quadrant;
import com.vsngarcia.client.ColorCamoElevator;
import com.vsngarcia.client.gui.ElevatorScreen;
import com.vsngarcia.level.ElevatorContainer;
import com.vsngarcia.neoforge.ElevatorBlock;
import com.vsngarcia.neoforge.client.render.ElevatorBakedModel;
import com.vsngarcia.neoforge.init.Registry;
import java.util.EnumMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.SingleVariant;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.model.standalone.SimpleUnbakedStandaloneModel;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="elevatorid", value={Dist.CLIENT})
public class ClientRegistry {
    public static final StandaloneModelKey<EnumMap<Direction, BlockStateModel>> ARROW_MODEL_KEY = new StandaloneModelKey(() -> "arrow");

    @SubscribeEvent
    public static void onMenuScreensRegistry(RegisterMenuScreensEvent e) {
        e.register(Registry.ELEVATOR_CONTAINER.get(), (container, inv, title) -> new ElevatorScreen((ElevatorContainer)container, inv, title, x$0 -> ClientPacketDistributor.sendToServer((CustomPacketPayload)x$0, (CustomPacketPayload[])new CustomPacketPayload[0])));
    }

    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        Registry.ELEVATOR_BLOCKS.values().forEach(b -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)b.get()), (ChunkSectionLayer)ChunkSectionLayer.TRANSLUCENT));
    }

    @SubscribeEvent
    public static void onBlockColorHandlersRegistry(RegisterColorHandlersEvent.Block e) {
        e.register((BlockColor)new ColorCamoElevator(), (Block[])Registry.ELEVATOR_BLOCKS.values().stream().map(DeferredHolder::get).toArray(ElevatorBlock[]::new));
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelEvent.RegisterStandalone e) {
        e.register(ARROW_MODEL_KEY, (UnbakedStandaloneModel)new SimpleUnbakedStandaloneModel(ResourceLocation.fromNamespaceAndPath((String)"elevatorid", (String)"arrow"), (model, baker) -> Direction.Plane.HORIZONTAL.stream().collect(Collectors.toMap(Function.identity(), dir -> new SingleVariant((BlockModelPart)SimpleModelWrapper.bake((ModelBaker)baker, (ResolvedModel)model, (ModelState)BlockModelRotation.by((Quadrant)Quadrant.R0, (Quadrant)Quadrant.parseJson((int)((int)dir.toYRot()))))), (o1, o2) -> o1, () -> new EnumMap(Direction.class)))));
    }

    @SubscribeEvent
    public static void onModelBake(ModelEvent.ModifyBakingResult e) {
        e.getBakingResult().blockStateModels().entrySet().stream().filter(entry -> ((BlockState)entry.getKey()).getBlock() instanceof ElevatorBlock).forEach(entry -> e.getBakingResult().blockStateModels().put((BlockState)entry.getKey(), new ElevatorBakedModel((BlockStateModel)entry.getValue())));
    }
}

