/*
 * Decompiled with CFR 0.152.
 */
package com.vsngarcia.network.client;

import com.vsngarcia.ElevatorBlockBase;
import com.vsngarcia.network.TeleportPacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public record SetArrowPacket(boolean value, BlockPos pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetArrowPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"elevatorid", (String)"set_arrow"));
    public static final StreamCodec<ByteBuf, SetArrowPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, SetArrowPacket::value, (StreamCodec)BlockPos.STREAM_CODEC, SetArrowPacket::pos, SetArrowPacket::new);

    public CustomPacketPayload.Type<SetArrowPacket> type() {
        return TYPE;
    }

    public static void handle(SetArrowPacket msg, ServerPlayer player) {
        if (TeleportPacket.isBadClientPacket((Player)player, msg.pos)) {
            return;
        }
        ServerLevel world = player.level();
        BlockState state = world.getBlockState(msg.pos);
        if (state.getBlock() instanceof ElevatorBlockBase) {
            world.setBlockAndUpdate(msg.pos, (BlockState)state.setValue((Property)ElevatorBlockBase.SHOW_ARROW, (Comparable)Boolean.valueOf(msg.value)));
        }
    }
}

