/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.CompilerDirectives;

public final class MathUtils {
    private static final double LN_2 = 0.6931471805599453;
    private static final double TWO_POW_M28 = 3.725290298461914E-9;
    private static final double TWO_POW_P28 = 2.68435456E8;

    private MathUtils() {
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static double asinh(double x2) {
        double w2;
        if (!Double.isFinite(x2)) {
            return x2 + x2;
        }
        double ax = Math.abs(x2);
        if (ax < 3.725290298461914E-9) {
            return x2;
        }
        if (ax > 2.68435456E8) {
            w2 = Math.log(ax) + 0.6931471805599453;
        } else if (ax > 2.0) {
            w2 = Math.log(2.0 * ax + 1.0 / (Math.sqrt(x2 * x2 + 1.0) + ax));
        } else {
            double t2 = x2 * x2;
            w2 = Math.log1p(ax + t2 / (1.0 + Math.sqrt(1.0 + t2)));
        }
        return Math.copySign(w2, x2);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static double acosh(double x2) {
        if (x2 < 1.0) {
            return (x2 - x2) / (x2 - x2);
        }
        if (x2 >= 2.68435456E8) {
            if (!Double.isFinite(x2)) {
                return x2 + x2;
            }
            return Math.log(x2) + 0.6931471805599453;
        }
        if (x2 == 1.0) {
            return 0.0;
        }
        if (x2 > 2.0) {
            double t2 = x2 * x2;
            return Math.log(2.0 * x2 - 1.0 / (x2 + Math.sqrt(t2 - 1.0)));
        }
        double t3 = x2 - 1.0;
        return Math.log1p(t3 + Math.sqrt(2.0 * t3 + t3 * t3));
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static double atanh(double x2) {
        double t2;
        double ax = Math.abs(x2);
        if (ax > 1.0) {
            return (x2 - x2) / (x2 - x2);
        }
        if (ax == 1.0) {
            return x2 / 0.0;
        }
        if (ax < 3.725290298461914E-9) {
            return x2;
        }
        if (ax < 0.5) {
            t2 = ax + ax;
            t2 = 0.5 * Math.log1p(t2 + t2 * ax / (1.0 - ax));
        } else {
            t2 = 0.5 * Math.log1p((ax + ax) / (1.0 - ax));
        }
        return Math.copySign(t2, x2);
    }
}

